;(function ($) {
  "use strict"

  function randomNum(maxNum) {
    return Math.floor(Math.random() * maxNum + 1) //return a number between 1 - 10
  }

  var pvm_container = $(".bwl_pvm_container"),
    pvm_like_btn = pvm_container.find(".btn_like"),
    pvm_dislike_btn = pvm_container.find(".btn_dislike"),
    vote_status,
    stat_cnt,
    post_id,
    bpvm_unique_id

  if (typeof pvm_tipsy_status != "undefined" && pvm_tipsy_status == 1) {
    // Initalized Tipsy
    $(".btn_like").tipsy({ fade: true, gravity: "s" })
    $(".btn_dislike").tipsy({ fade: true, gravity: "n" })
  }

  function pvm_trigger_vote_count() {
    $(".stat-cnt").each(function () {
      var $this = $(this)

      var $total_vote_counter = $this.find(".total-vote-counter")

      var $like_count_container = $this.find(".like-count-container"),
        $dislike_count_container = $this.find(".dislike-count-container")

      var $total_diff = $like_count_container.find("span").text() - $dislike_count_container.find("span").text()
      //   alert($like_count_container.find("span").text())
      //   alert($dislike_count_container.find("span").text())
      //   alert($total_diff)

      $total_vote_counter.find("span").html($total_diff)
    })
  }

  //   pvm_trigger_vote_count()

  $(document).on("click", ".btn_like", function () {
    var parent_section = $(this).closest(".bwl_pvm_container")
    parent_section.addClass("pvm_overlay")
    vote_status = $(this).attr("vote_status")
    post_id = $(this).attr("post_id")
    bpvm_unique_id = $(this).attr("bpvm_unique_id")
    stat_cnt = $("#stat-cnt-" + bpvm_unique_id)

    if (pvm_tipsy_status == 1) {
      // Hide Tipsy
      $("#pvm_btn_container_" + bpvm_unique_id)
        .find(".btn_like")
        .tipsy("hide")
      $("#pvm_btn_container_" + bpvm_unique_id)
        .find(".btn_dislike")
        .tipsy("hide")
    }

    $("#pvm_btn_container_" + bpvm_unique_id).append('<div class="msg_container">' + bpvmFrontendData.pvm_wait_msg + "</div>")

    pvm_count_vote(stat_cnt, vote_status, post_id, bpvm_unique_id, parent_section)
  })

  $(document).on("click", ".btn_dislike", function () {
    var parent_section = $(this).closest(".bwl_pvm_container")
    parent_section.addClass("pvm_overlay")
    vote_status = $(this).attr("vote_status")
    post_id = $(this).attr("post_id")
    bpvm_unique_id = $(this).attr("bpvm_unique_id")
    stat_cnt = $("#stat-cnt-" + bpvm_unique_id)

    if (pvm_tipsy_status == 1) {
      // Hide Tipsy
      $("#pvm_btn_container_" + bpvm_unique_id)
        .find(".btn_like")
        .tipsy("hide")
      $("#pvm_btn_container_" + bpvm_unique_id)
        .find(".btn_dislike")
        .tipsy("hide")
    }

    $("#pvm_btn_container_" + bpvm_unique_id).append('<div class="msg_container">' + bpvmFrontendData.pvm_wait_msg + "</div>")
    pvm_count_vote(stat_cnt, vote_status, post_id, bpvm_unique_id, parent_section)
  })

  function pvm_count_vote(stat_cnt, vote_status, post_id, bpvm_unique_id, parent_section) {
    var msg_icon = ""
    var tfa_status,
      tfa_vis = "",
      tfa_vie = ""

    if ($(".pvm_dynamic_sort_wrapper").length > 0) {
      var $pvm_dynamic_sort_wrapper = $(".pvm_dynamic_sort_wrapper"),
        tfa_status = 1,
        tfa_vis = $pvm_dynamic_sort_wrapper.data("start"),
        tfa_vie = $pvm_dynamic_sort_wrapper.data("end")
    }

    $.ajax({
      url: bpvmFrontendData.ajaxurl,
      type: "POST",
      dataType: "JSON",
      data: {
        action: "bwl_pvm_add_rating", // action will be the function name
        nonce: bpvmFrontendData.bpvm_frontend_nonce,
        count_vote: true,
        post_id: post_id,
        vote_status: vote_status,
        tfa: tfa_status,
        tfa_vis: tfa_vis,
        tfa_vie: tfa_vie,
      },
      success: function (data) {
        parent_section.removeClass("pvm_overlay")

        if (data.status == 1) {
          stat_cnt.find(".total-vote-counter span").html(data.total_vote_counter)
          stat_cnt.find(".like-count-container span").html(data.like_vote_counter)
          stat_cnt.find(".dislike-count-container span").html(data.dislike_vote_counter)

          stat_cnt.find(".like_percentage").attr("style", "width:" + data.like_percentage + "%")
          stat_cnt.find(".dislike_percentage").attr("style", "width:" + data.dislike_percentage + "%")
        }

        if (vote_status == 0 && data.status == 1 && pvm_disable_feedback_status == 0 && $("#pvm_feedback_form_" + bpvm_unique_id).length == 1) {
          $("#pvm_feedback_form_" + bpvm_unique_id).slideDown("slow", function () {
            var form_field_container = $("#pvm_feedback_form_" + bpvm_unique_id + " .bwl_pvm_feedback_form"),
              feedback_message_box = form_field_container.find(".feedback_message_box"),
              captcha = form_field_container.find("#captcha"),
              all_fields = $([]).add(feedback_message_box).add(captcha)

            all_fields.removeAttr("disabled").removeClass("bwl_pvm_feedback_disabled_field").val("")

            form_field_container.find("input[type=submit]").removeAttr("disabled")
          })
        }

        $("#pvm_btn_container_" + bpvm_unique_id)
          .find('div[class*="btn_"]')
          .hide()
        $("#pvm_btn_container_" + bpvm_unique_id)
          .find(".msg_container")
          .html(msg_icon + " " + data.msg)

        /*--- Attach Tooltip on Share bUtton ------*/

        if ($(".btn-share").length > 0 && pvm_tipsy_status == 1) {
          setTimeout(function () {
            $(".btn-share").tipsy({ fade: true, gravity: "n" })
          }, 100)

          // Custom Share Link
          // @since: version 1.1.2

          $(".pvm_share").click(function () {
            var bwl_bpvm_share_btn = window.open($(this).prop("href"), "", "menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600")
            if (window.focus) {
              bwl_bpvm_share_btn.focus()
            }
            return false
          })
        }
      },
      error: function (xhr, textStatus, e) {
        parent_section.removeClass("pvm_overlay")
        $("#pvm_btn_container_" + bpvm_unique_id).html('<div class="msg_container"> ' + msg_icon + " Sorry! We are unable to collect your vote!</div>")
        return
      },
    })
  }

  /*--- Form Submission---*/

  $(".bwl_pvm_feedback_form")
    .find("input[type=submit]")
    .on("click", function () {
      var form_submit_button = $(this),
        bwl_pvm_feedback_form_id = form_submit_button.attr("bwl_pvm_feedback_form_id"),
        form_box_container = $("#" + bwl_pvm_feedback_form_id),
        form_field_container = $("#" + bwl_pvm_feedback_form_id + " .bwl_pvm_feedback_form")

      var bwl_pro_form_error_message_box = form_box_container.find(".bwl_pro_form_error_message_box"),
        feedback_message_box = form_field_container.find(".feedback_message_box"),
        captcha_status = form_field_container.find("#captcha_status")

      if (captcha_status.val() == 1) {
        var num1 = form_field_container.find("#num1")
        var num2 = form_field_container.find("#num2")
        var captcha = form_field_container.find("#captcha")
        var all_fields = $([]).add(feedback_message_box).add(captcha)
      } else {
        var all_fields = $([]).add(feedback_message_box)
      }

      var bValid = true,
        feedback_message_bValid,
        captcha_bValid,
        required_field_msg = "",
        ok_border = "border: 1px solid #EEEEEE",
        error_border = "border: 1px solid #E63F37"

      if ($.trim(feedback_message_box.val()).length < 3) {
        feedback_message_bValid = false
        feedback_message_box.attr("style", error_border)
        required_field_msg += " " + err_feedback_msg + "<br />"
      } else {
        feedback_message_bValid = true
        feedback_message_box.attr("style", ok_border)
        required_field_msg += ""
      }

      bValid = bValid && feedback_message_bValid

      if (captcha_status.val() == 1) {
        if (parseInt($.trim(num1.val())) + parseInt($.trim(num2.val())) != parseInt($.trim(captcha.val()))) {
          captcha_bValid = false
          captcha.attr("style", error_border)
          required_field_msg += " " + err_pvm_captcha
        } else {
          captcha_bValid = true
          captcha.attr("style", ok_border)
          required_field_msg += ""
        }

        bValid = bValid && captcha_bValid
      }

      //Alert Message Box For Required Fields.

      if (bValid == false) {
        bwl_pro_form_error_message_box.html("").addClass("bwl-form-error-box").html(required_field_msg).slideDown("slow")
      }

      if (bValid == true) {
        all_fields.attr("style", ok_border)
        all_fields.addClass("bwl_pvm_feedback_disabled_field").attr("disabled", "disabled")
        form_submit_button.addClass("bwl_pvm_feedback_disabled_field").attr("disabled", "disabled")
        bwl_pro_form_error_message_box.html("").removeClass("bwl-form-error-box").addClass("bwl-form-wait-box").html(bpvmFrontendData.pvm_wait_msg).slideDown("slow")

        $.ajax({
          url: bpvmFrontendData.ajaxurl,
          type: "POST",
          dataType: "JSON",
          data: {
            action: "bwl_pvm_save_post_data",
            nonce: bpvmFrontendData.bpvm_frontend_nonce,
            feedback_message_box: feedback_message_box.val(),
            post_id: form_submit_button.attr("post_id"),
            post_type: form_field_container.find("#post_type").val(),
          },
          success: function (data) {
            if (data.pvm_feedback_status == 1) {
              //Reload For New Number.

              if (captcha_status.val() == 1) {
                num1.val(randomNum(5))
                num2.val(randomNum(9))
              }

              bwl_pro_form_error_message_box
                .removeClass("bwl-form-wait-box")
                .html("")
                .html(pvm_feedback_thanks_msg)
                .addClass("bwl-form-success-box")
                .delay(3000)
                .slideUp("slow", function () {
                  $("#" + bwl_pvm_feedback_form_id).slideUp("slow", function () {
                    $(this).remove()
                  })
                })
            } else {
              bwl_pro_form_error_message_box.removeClass("bwl-form-wait-box").html("").html(pvm_unable_feedback_msg).addClass("bwl-form-error-box").delay(3000).slideUp("slow")
              all_fields.removeAttr("disabled").removeClass("bwl_pvm_feedback_disabled_field")
              form_submit_button.removeAttr("disabled").removeClass("bwl_pvm_feedback_disabled_field")
            }
          },
          error: function (xhr, textStatus, e) {
            bwl_pro_form_error_message_box.removeClass("bwl-form-wait-box").html("").html(pvm_unable_feedback_msg).addClass("bwl-form-error-box").delay(3000).slideUp("slow")
            all_fields.removeAttr("disabled").removeClass("bwl_pvm_feedback_disabled_field")
            form_submit_button.removeAttr("disabled").removeClass("bwl_pvm_feedback_disabled_field")
            return
          },
        })
      }

      return false
    })

  /*------------------------------ bpvm_filter_vbox  ---------------------------------*/

  if ($(".bpvm_filter_vbox").length > 0) {
    $(".bpvm_filter_vbox").each(function () {
      var $this = $(this)

      $this.find(".stat-cnt").remove()

      $this.find(".btn_like, .btn_dislike").on("click", function () {
        $this
          .find(".pvm_btn_container")
          .css({
            width: "100%",
          })
          .attr("data-class", "bpvm_filter_vbox")

        $this.removeClass("bpvm_filter_vbox")
      })
    })
  }
})(jQuery)
