;(function ($) {
  "use strict"

  function updateUrlParams() {
    // const formData = new FormData(form)
    const params = new URLSearchParams()

    const formData = {
      page: "bpvm-voting-report",
    }

    formData.ptype = $("#mv_bpvm_post_type").val()
    formData.pid = 19

    for (const [key, value] of Object.entries(formData)) {
      if (value) {
        params.set(key, value)
      }
    }
    // ?page=bpvm-voting-report&pt=post&pid=10
    const newUrl = `${window.location.pathname}?${params.toString()}`
    // const newUrl = window.location.pathname
    // console.log(newUrl)
    history.pushState(null, "", newUrl)
  }

  /*--- Vote Reporting ---*/

  function bpvm_get_posts(post_type) {
    return $.ajax({
      type: "POST",
      url: ajaxurl,
      data: {
        action: "bpvm_get_posts_data", // this is the name of our WP AJAX function that we'll set up next
        post_type: post_type,
      },
      dataType: "JSON",
    })
  }

  function bpvm_data_table() {
    var post_type = $mv_bpvm_post_type.val(),
      post_id = $mv_post_title.val(),
      mv_post_filters = $mv_post_filters.val(),
      mv_vote_info_type = $mv_vote_info_type.val(),
      pvm_custom_date_range = $pvm_custom_date_range.is(":checked"),
      pvm_filter_start_date = $pvm_filter_start_date.val(),
      pvm_filter_end_date = $pvm_filter_end_date.val()

    const $bpvm_data_table = $("#bpvm-data-table")
    const bpvm_data_table_overlay_class = "bpvm_data_table_overlay"

    $bpvm_data_table.DataTable().destroy()

    $bpvm_data_table.removeClass("dn")

    $("#bpvm-data-table_wrapper").show()

    const dataTable = $bpvm_data_table.DataTable({
      processing: true,
      serverSide: true,
      searching: false,
      order: [[0, "desc"]],
      columnDefs: [
        {
          targets: 0,
          orderable: false,
          searchable: false,
        },
      ],
      ajax: {
        url: bpvmAdminData.ajaxurl,
        type: "POST",
        data: function (d) {
          d.action = "pvm_voting_stats"
          d._ajax_nonce = bpvmAdminData.nonce
          d.post_id = post_id
          d.post_type = post_type
          d.mv_post_filters = mv_post_filters
          d.mv_vote_info_type = mv_vote_info_type
          d.pvm_custom_date_range = pvm_custom_date_range
          d.pvm_filter_start_date = pvm_filter_start_date
          d.pvm_filter_end_date = pvm_filter_end_date
        },
      },
      columns: [{ data: "ID" }, { data: "vote_date" }, { data: "vote_type" }, { data: "votes" }],
    })

    var $bpvm_data_table_wrapper = $("#bpvm-data-table_wrapper")

    // Bulk Delete Section.

    $("#bpvm_bulkdelete").prop("checked", false)

    $("#bpvm_bulkdelete").on("click", function () {
      // bulk checked
      var status = this.checked
      $(".deleteRow").each(function () {
        $(this).prop("checked", status)
      })
    })

    $("#deleteTriger").on("click", function (event) {
      // triggering delete one by one

      if ($mv_vote_info_type.val() == 2 && confirm("Delete data?")) {
        if ($(".deleteRow:checked").length > 0) {
          // at-least one checkbox checked
          $bpvm_data_table_wrapper.addClass(bpvm_data_table_overlay_class)
          //                        var ids = [];
          var bpvm_data_array = new Array(),
            bpvm_data_stack = new Array()

          $(".deleteRow").each(function () {
            if ($(this).is(":checked")) {
              //                                console.log($(this).val());
              //                                ids.push($(this).val(), $(this).data('post_id'));
              bpvm_data_array = [$(this).val(), $(this).data("votes"), $(this).data("vote_type"), $(this).data("vote_date")]
              bpvm_data_stack.push(bpvm_data_array)
            }
          })
          //                        console.log(bpvm_data_stack);
          //                        var ids_string = ids.toString();  // array to string conversion
          //                        console.log(ids_string);
          //                        return '';

          $.when(bpvm_remove_data(post_type, post_id, bpvm_data_stack)).done(function (response_data) {
            dataTable.draw() // redrawing datatable
            $("#bpvm_bulkdelete").prop("checked", false)
            setTimeout(function () {
              $bpvm_data_table_wrapper.removeClass(bpvm_data_table_overlay_class)
            }, 3000)
          })
        } else {
          alert("Please select rows.")
        }
      } else {
        return false
      }
    })
  }

  function bpvm_remove_data(post_type, post_id, bpvm_data_stack) {
    return $.ajax({
      type: "POST",
      url: ajaxurl + "?action=bpvm_delete_vote_data",
      data: {
        post_type: post_type,
        post_id: post_id,
        bpvm_data_stack: bpvm_data_stack,
      },
      dataType: "JSON",
    })
  }

  function bpvm_update_vote_data(post_type, post_id, pvm_mv_date, pvm_mv_vote_type, pvm_manual_votes) {
    return $.ajax({
      type: "POST",
      url: ajaxurl,
      data: {
        action: "bpvm_update_vote_data", // this is the name of our WP AJAX function that we'll set up next
        post_id: post_id,
        post_type: post_type,
        pvm_mv_date: pvm_mv_date,
        pvm_mv_vote_type: pvm_mv_vote_type,
        pvm_manual_votes: pvm_manual_votes,
      },
      dataType: "JSON",
    })
  }

  /*----- Start validation Function ----*/
  function updateTips(t) {
    tips.removeClass("dn").text(t).addClass("pvm-error-msg").attr("style", "")
  }

  function checkLength(o, n, min, max, msg) {
    if (o.val().length > max || o.val().length < min) {
      o.addClass("ui-state-error")

      if (typeof msg != "undefined") {
        updateTips(msg)
      } else {
        updateTips("Length of " + n + " must be between " + min + " and " + max + ".")
      }

      return false
    } else {
      return true
    }
  }

  function checkRegexp(o, regexp, n) {
    if (!regexp.test(o.val())) {
      o.addClass("ui-state-error")
      updateTips(n)
      return false
    } else {
      return true
    }
  }

  function checkIsSelected(o, n) {
    if (o.val() == "") {
      o.addClass("ui-state-error")
      updateTips("Select " + n + ".")
      return false
    } else {
      return true
    }
  }

  if ($("#pvm_voting_report_page").length) {
    var $pvm_ctrl_section = $(".ctrl-section"),
      $action_msg_box = $(".action-msg-box"),
      $action_msg_box_default_msg = $(".action-msg-box").html(),
      $mv_bpvm_post_type = $pvm_ctrl_section.find("#mv_bpvm_post_type"),
      $mv_post_title = $pvm_ctrl_section.find("#mv_post_title"),
      $mv_post_filters = $pvm_ctrl_section.find("#mv_post_filters"),
      $mv_vote_info_type = $pvm_ctrl_section.find("#mv_vote_info_type"),
      $pvm_custom_date_range = $pvm_ctrl_section.find("#pvm_custom_date_range"),
      $pvm_filter_start_date = $pvm_ctrl_section.find("#pvm_filter_start_date"),
      $pvm_filter_end_date = $pvm_ctrl_section.find("#pvm_filter_end_date"),
      $mv_pvm_go = $("#mv_pvm_go"),
      $pvm_amv = $("#pvm_amv"),
      $pvm_download_report = $("#pvm_download_report"),
      $bpvm_admin_loader = $("#bpvm-admin-loader")

    var $pvm_ctrl_items = $([]).add($mv_post_title).add($mv_post_filters).add($mv_vote_info_type).add($pvm_custom_date_range).add($pvm_filter_start_date).add($pvm_filter_end_date).add($mv_pvm_go).add($pvm_amv).add($pvm_download_report)
    $mv_bpvm_post_type.val("")
    $mv_post_filters.val("")
    $mv_vote_info_type.val(1)
    $pvm_ctrl_items.attr("disabled", "disabled")

    var $deleteTriger = $("#deleteTriger")

    /*--- Date Range Filter ---*/

    var $pvm_date_range_items = $([]).add($pvm_filter_start_date).add($pvm_filter_end_date)

    $pvm_custom_date_range.prop("checked", false)
    $pvm_date_range_items.val("")

    $pvm_custom_date_range.on("click", function () {
      if ($pvm_custom_date_range.is(":checked")) {
        $pvm_date_range_items.val("").removeAttr("disabled")
      } else {
        $pvm_date_range_items.val("").attr("disabled", "disabled")
      }
    })

    // Filter Start Date.

    $pvm_filter_start_date.datepicker({
      defaultDate: "+1w",
      changeMonth: true,
      dateFormat: "yy-mm-dd",
      numberOfMonths: 1,
      onSelect: function (selectedDate) {
        $pvm_filter_end_date.datepicker("option", "minDate", selectedDate)
      },
    })

    $pvm_filter_end_date.datepicker({
      defaultDate: "+1w",
      changeMonth: true,
      dateFormat: "yy-mm-dd",
      numberOfMonths: 1,
      onSelect: function (selectedDate) {
        $pvm_filter_start_date.datepicker({ maxDate: selectedDate })
      },
    })

    var $pvm_msg_container = $("#pvm_msg_container"),
      $mv_post_title_default_option_value = $("#mv_post_title").find("option:first")

    $pvm_msg_container.html("")

    $mv_bpvm_post_type.on("change", function () {
      var post_type = $(this).val()

      $bpvm_admin_loader.removeClass("dn").addClass("dib")

      if (post_type == "") {
        $bpvm_admin_loader.removeClass("dib").addClass("dn")
        $pvm_ctrl_items.attr("disabled", "disabled")
        return false
      }
      $mv_post_title.attr("disabled", "disabled")

      $.when(bpvm_get_posts(post_type)).done(function (response_data) {
        $bpvm_admin_loader.removeClass("dib").addClass("dn")

        if (response_data.status == 1) {
          $mv_post_title.html($mv_post_title_default_option_value)

          var posts = ""

          $.each(response_data.data, function (index, data) {
            posts += '<option value="' + data["post_id"] + '">' + data["post_title"] + "</option>"
          })

          $mv_post_title.find("option:first").after(posts)
          $mv_post_title.removeAttr("disabled")
          $pvm_download_report.removeAttr("disabled")
        } else {
          $mv_post_title.html($mv_post_title_default_option_value)
          $pvm_ctrl_items.attr("disabled", "disabled")
        }
      })
    })

    // On Post Change We Will Remove Disable of Buttons.

    $mv_post_title.on("change", function () {
      var post_title = $(this).val()

      if (post_title == "") {
        $pvm_ctrl_items.attr("disabled", "disabled")
        return false
      }

      $pvm_ctrl_items.removeAttr("disabled")
      $pvm_date_range_items.attr("disabled", "disabled")

      $deleteTriger.unbind("click")

      bpvm_data_table()
    })

    // On change Voting Filter Type.

    $mv_post_filters.on("change", function () {
      $deleteTriger.unbind("click")

      bpvm_data_table()
    })

    // On change Voting Info Type.

    $mv_vote_info_type.on("change", function () {
      $deleteTriger.unbind("click")

      bpvm_data_table()
    })

    // Go Events.

    $mv_pvm_go.on("click", function () {
      $deleteTriger.unbind("click")

      bpvm_data_table()
    })

    // Modal Section.

    /*--- Manual Vote Add ---*/

    var $pvm_amv = $("#pvm_amv"),
      $pvm_rmv = $("#pvm_rmv"),
      $pvm_manual_voting_modal = $("#pvm-manual-voting-modal"),
      $pvm_mv_date = $pvm_manual_voting_modal.find("#pvm_mv_date"),
      $pvm_mv_vote_type = $pvm_manual_voting_modal.find("#pvm_mv_vote_type"),
      $pvm_manual_votes = $pvm_manual_voting_modal.find("#pvm_manual_votes"),
      $pvm_mv_items = $([]).add($pvm_mv_date).add($pvm_mv_vote_type).add($pvm_manual_votes),
      tips = $(".message-text"),
      numberRegex = /^[0-9]*$/

    $("#pvm-manual-voting-modal").dialog({
      autoOpen: false,
      resizable: false,
      width: 400,
      height: 250,
      modal: true,
      buttons: {
        Save: function () {
          var bValid = true
          $pvm_mv_items.removeClass("ui-state-error")

          var id = $(this).data("id")

          bValid = bValid && checkLength($pvm_mv_date, "Date", 2, 100, "Date Field is Required !")
          bValid = bValid && checkIsSelected($pvm_mv_vote_type, "Vote Type")
          bValid = bValid && checkLength($pvm_manual_votes, "", 1, 100, "Add Vote Number !")
          bValid = bValid && checkRegexp($pvm_manual_votes, numberRegex, "Only Numbers")

          if (bValid) {
            $pvm_ctrl_items.attr("disabled", "disabled")
            $(this).dialog("close")
            $action_msg_box.html("Saving. Please Wait .....")

            var post_type = $mv_bpvm_post_type.val()
            var post_id = $mv_post_title.val()

            $.when(bpvm_update_vote_data(post_type, post_id, $pvm_mv_date.val(), $pvm_mv_vote_type.val(), $pvm_manual_votes.val())).done(function (response_data) {
              if (response_data.status == 1) {
                $action_msg_box.html("Saved !")
                bpvm_data_table()

                setTimeout(function () {
                  $action_msg_box.html($action_msg_box_default_msg)
                  $pvm_ctrl_items.removeAttr("disabled", "disabled")
                }, 3000)

                $pvm_mv_items.val("")
              }
            })
          }
        },
      },
      close: function () {
        $(this).dialog("close")
      },
    })

    $(document).on("click", "#pvm_amv", function () {
      $deleteTriger.unbind("click")

      var $pvm_manual_voting_modal = $("#pvm-manual-voting-modal")

      // Initialize All The Modal Values.
      tips.addClass("dn").html("").attr("style", "")
      $pvm_mv_items.val("").removeClass("ui-state-error")

      //Attach Date Picker With Voting Date.
      $pvm_mv_date.datepicker({
        changeMonth: true,
        dateFormat: "yy-mm-dd",
        numberOfMonths: 1,
      })

      $pvm_manual_voting_modal
        .data("id", $(this).data("post_id")) // The important part .data() method
        .dialog("open")
    })
  }
})(jQuery)
