export default class ResetReport {
  /**
   * Run when the document is ready.
   *
   * @return {void}
   */

  constructor() {
    // Use the globally loaded jQuery instance
    this.$ = window.jQuery
    this.cache()
  }

  cache() {
    this.resetBtn = this.$(document).find("#pvm_reset_report")
  }

  resetReport() {
    if (this.resetBtn.length) {
      this.resetBtn.on("click", (e) => {
        e.preventDefault()

        if (confirm("Are you sure you want to reset the report?")) {
          this.$("#bpvm-report-filter-form").trigger("reset")

          this.$("#bpvm-data-table_wrapper").hide()

          const filter_form = this.$("#bpvm-report-filter-form")

          filter_form.trigger("reset")
          filter_form.find("input").attr("disabled", true)
          filter_form.find("select").attr("disabled", true)
          filter_form.find("#mv_bpvm_post_type").removeAttr("disabled")
          filter_form.find("#pvm_reset_report").removeAttr("disabled")
        }
      })
    }
  }

  // Run the functions.

  docReady() {
    this.resetReport()
  }
}
