export default class RefreshVotingData {
  /**
   * Run when the document is ready.
   *
   * @return {void}
   */

  constructor() {
    // Use the globally loaded jQuery instance
    this.$ = window.jQuery
    this.cache()
  }

  cache() {
    this.bpvmRefreshDataBtn = this.$(document).find("#bpvm_refresh_data")
    this.bpvmTotalVotesCount = this.$(document).find("#bpvm_total_votes_count")
    this.bpvmTotalLikesCount = this.$(document).find("#bpvm_total_likes_count")
    this.bpvmTotalDislikesCount = this.$(document).find("#bpvm_total_dislikes_count")
    this.loaderIcon = `<img src="${bpvmAdminData.bpvm_libs_dir}images/loader.gif" alt="Loading..." /> Refreshing voting data...`
  }

  sendRefreshRequest() {
    return this.$.ajax({
      type: "POST",
      url: bpvmAdminData.ajaxurl,
      data: {
        action: "bpvm_refresh_voting_data",
      },
      dataType: "JSON",
    })
  }

  initRefreshVotingData() {
    if (this.bpvmRefreshDataBtn.length) {
      this.bpvmRefreshDataBtn.on("click", (e) => {
        e.preventDefault()

        let oldIcon = this.bpvmRefreshDataBtn.html()

        this.bpvmRefreshDataBtn.html(this.loaderIcon)
        this.bpvmRefreshDataBtn.prop("disabled", true)
        this.$.when(this.sendRefreshRequest()).done((response_data) => {
          this.bpvmRefreshDataBtn.html(oldIcon)

          const { likes, dislikes } = response_data.data
          const total_votes = parseInt(likes) + parseInt(dislikes)

          this.bpvmTotalVotesCount.text(parseInt(total_votes))
          this.bpvmTotalLikesCount.text(likes)
          this.bpvmTotalDislikesCount.text(dislikes)
          this.bpvmRefreshDataBtn.prop("disabled", false)
        })
      })
    }
  }

  // Run the functions.

  docReady() {
    this.initRefreshVotingData()
  }
}
