;(function ($) {
  "use strict"

  // Editor Part

  function bwl_pvm_add_sc_action() {
    var $bpvm_parent_container = $("#bwl_pvm_editor_popup")

    /*------------------------------  All Fields ---------------------------------*/
    var post_type_container = $bpvm_parent_container.find(".post_type_container"),
      thumbnail_container = $bpvm_parent_container.find(".thumbnail_container"),
      date_filter_container = $bpvm_parent_container.find(".date_filter_container"),
      interval_container = $bpvm_parent_container.find(".interval_container"),
      custom_interval_container = $bpvm_parent_container.find(".custom_interval_container"),
      limit_container = $bpvm_parent_container.find(".limit_container"),
      orderby_container = $bpvm_parent_container.find(".orderby_container"),
      order_container = $bpvm_parent_container.find(".order_container"),
      animation_container = $bpvm_parent_container.find(".animation_container"),
      like_theme_container = $bpvm_parent_container.find(".like_theme_container"),
      dislike_theme_container = $bpvm_parent_container.find(".dislike_theme_container")

    var voting_theme_panel = $([]).add(like_theme_container).add(dislike_theme_container)
    var voting_panel_items = $([]).add(animation_container).add(voting_theme_panel)
    var custom_filter_items = $([]).add(post_type_container).add(thumbnail_container).add(date_filter_container).add(interval_container).add(custom_interval_container).add(limit_container).add(orderby_container).add(order_container)

    /*------------------------------ Voting Interval Date ---------------------------------*/

    /*------------------------------ Voting Date Range Picker ---------------------------------*/

    if ($("#bpvm_interval_start").length && $("#bpvm_interval_end").length) {
      var $bpvm_interval = $("#bpvm_interval"),
        $bpvm_interval_start = $("#bpvm_interval_start"),
        $bpvm_interval_end = $("#bpvm_interval_end"),
        $bpvm_custom_interval_container = $("#custom_interval_container")

      $bpvm_interval_start.datepicker({
        defaultDate: "+1w",
        changeMonth: true,
        dateFormat: "yy-mm-dd",
        numberOfMonths: 1,
        onSelect: function (selectedDate) {
          $bpvm_interval_end.datepicker("option", "minDate", selectedDate)
        },
      })

      $bpvm_interval_end.datepicker({
        defaultDate: "+1w",
        changeMonth: true,
        dateFormat: "yy-mm-dd",
        numberOfMonths: 1,
        onSelect: function (selectedDate) {
          $bpvm_interval_start.datepicker({ maxDate: selectedDate })
        },
      })
    }

    // Animation Filter.

    animation_container.find("input[type=checkbox]").change(function () {
      if (this.checked) {
        voting_theme_panel.find("select").removeAttr("disabled").val("")
      } else {
        voting_theme_panel.find("select").attr("disabled", "disabled").val("")
      }
    })

    var custom_selection = $("input[name=custom_selection]")

    custom_selection.change(function () {
      if ($(this).val() == 2) {
        voting_panel_items.addClass("bpvm_dn")
        custom_filter_items.removeClass("bpvm_dn")
      } else {
        custom_filter_items.addClass("bpvm_dn")
        voting_panel_items.removeClass("bpvm_dn")
      }
    })

    $("#addShortCodebtn").on("click", function (event) {
      // INITIALIZE ALL SHORTCODE TEXT

      var bpvm_shortcode = "["

      if ($("input:radio[name=custom_selection]:checked").val() == 2) {
        // Insert Custom Filter Shortcode.

        // Insert Filter Panel.

        bpvm_shortcode += "bpvm_filter"

        // Post Type Filter

        if (post_type_container.find("#bpvm_post_type").val().length !== 0) {
          bpvm_shortcode += ' post_type="' + post_type_container.find("#bpvm_post_type").val() + '"'
        }

        // Thumbnail Filter

        if (thumbnail_container.find("#bpvm_thumbnail_filter").is(":checked")) {
          bpvm_shortcode += ' thumb="1" '
        } else {
          bpvm_shortcode += ' thumb="0" '
        }

        // Day Filter Status.

        if (animation_container.find("#bpvm_date_filter").is(":checked")) {
          bpvm_shortcode += ' date_filter="1" '
        }

        // Interval Filter.

        if (interval_container.find("#bpvm_interval").val().length !== 0) {
          bpvm_shortcode += ' interval="' + $("#bpvm_interval").val() + '" '
        }

        // Interval Start Date

        if (interval_container.find("#bpvm_interval").val() == "custom" && custom_interval_container.find("#bpvm_interval_start").val().length !== 0 && custom_interval_container.find("#bpvm_interval_start").val() != "") {
          bpvm_shortcode += ' vis="' + $("#bpvm_interval_start").val() + '" '
        }

        // Interval End Date

        if (interval_container.find("#bpvm_interval").val() == "custom" && custom_interval_container.find("#bpvm_interval_end").val().length !== 0 && custom_interval_container.find("#bpvm_interval_end").val() != "") {
          bpvm_shortcode += ' vie="' + $("#bpvm_interval_end").val() + '" '
        }

        // Orderby Filter.

        if (orderby_container.find("#bpvm_orderby").val().length !== 0) {
          bpvm_shortcode += ' order_type="' + orderby_container.find("#bpvm_orderby").val() + '" '
        }

        // Order Filter.

        if (order_container.find("#bpvm_order").val().length !== 0) {
          bpvm_shortcode += ' order="' + order_container.find("#bpvm_order").val() + '" '
        }

        // Limit Filter.

        if (limit_container.find("#bpvm_limit").val().length !== 0) {
          bpvm_shortcode += ' limit="' + limit_container.find("#bpvm_limit").val() + '" '
        }
      } else {
        // Insert Voting Panel.

        bpvm_shortcode += "bwl_pvm"

        // Voitng Animation Bar Shortcode.

        if (animation_container.find("#bpvm_animation").is(":checked")) {
          bpvm_shortcode += ' animation="1" '
        }

        // Like Theme.

        if (voting_theme_panel.find("#bpvm_like_theme").val().length !== 0) {
          bpvm_shortcode += ' like_theme="' + voting_theme_panel.find("select#bpvm_like_theme").val() + '"'
        }

        // Dislike Theme.

        if (voting_theme_panel.find("#bpvm_dislike_theme").val().length !== 0) {
          bpvm_shortcode += ' dislike_theme="' + voting_theme_panel.find("select#bpvm_dislike_theme").val() + '"'
        }
      }

      bpvm_shortcode += " /]"

      window.send_to_editor(bpvm_shortcode)

      $("#bwl_pvm_editor_overlay").remove()

      return false
    })

    $("#closeShortCodebtn, .btn_pvm_editor_close").on("click", function (event) {
      $("#bwl_pvm_editor_overlay").remove()
      return false
    })

    custom_filter_items.addClass("bpvm_dn")
    voting_panel_items.removeClass("bpvm_dn")

    /*------------------------------ Single Posts ---------------------------------*/

    $("select#bpvm_post_items").add("multiple", "multiple")

    $("select#bpvm_post_items").multipleSelect({
      placeholder: "- Select -",
      selectAll: true,
      filter: true,
    })

    $("select#bpvm_post_items").multipleSelect("uncheckAll")

    interval_container.find("#bpvm_interval").on("keypress", function (evt) {
      var charCode = evt.which ? evt.which : evt.keyCode
      if (charCode > 31 && (charCode < 48 || charCode > 57)) return false
      return true
    })

    interval_container.find("#bpvm_limit").on("keypress", function (evt) {
      var charCode = evt.which ? evt.which : evt.keyCode
      if (charCode > 31 && (charCode < 48 || charCode > 57)) return false
      return true
    })

    // Enable Drag Drop Of Editor

    $("#bwl_pvm_editor_popup").draggable({ cursor: "move" })
  }

  function handle_bwl_pvm_sc_content() {
    return $.ajax({
      url: ajaxurl,
      type: "POST",
      dataType: "HTML",
      data: {
        action: "bwl_pvm_sc_content", // action will be the function name
      },
    })
  }

  /*-- Start TinyMCE Integration Code --*/

  tinymce.create("tinymce.plugins.bwl_pvm", {
    init: function (ed, url) {
      ed.addButton("bwl_pvm", {
        title: "BWL Pro Voting Shortcode Editor",
        image: bpvmAdminData.bpvm_dir + "libs/tinymce/images/bwl-pvm-editor-icon.png",
        onclick: function () {
          if ($("#shortcode_controle").length) {
            $("#shortcode_controle").remove()
          } else {
            var bpvm_sc_loading_icon = '<img src="' + bpvmAdminData.bpvm_dir + 'libs/tinymce/images/load_icon.gif" class="bpvm_sc_load_icon"></img>'

            // dynamically append the editor.
            $("body").append('<div id="bwl_pvm_editor_overlay"><div id="bwl_pvm_editor_popup">' + bpvm_sc_loading_icon + "</div></div>")

            $.when(handle_bwl_pvm_sc_content()).done(function (data) {
              $("#bwl_pvm_editor_popup").html("").html(data).draggable({ cursor: "move" })
              bwl_pvm_add_sc_action()
            })
          }
        },
      })
    },
    createControl: function (n, cm) {
      return null
    },
  })

  tinymce.PluginManager.add("bwl_pvm", tinymce.plugins.bwl_pvm)
})(jQuery)
