<?php

function bpvm_clean_custom_post_types() {

    $available_bpvm_post_types = get_post_types();

    $pvm_data = get_option( 'bwl_pvm_options' );

    // Some unset function.
    // @Updated: 1.1.1 (22-01-2015)

    if ( class_exists( 'TribeEvents' ) ) {

        $removed_items = [ 'attachment', 'revision', 'nav_menu_item', 'tribe_venue', 'tribe_organizer', 'product_variation', 'shop_order', 'shop_order_refund', 'shop_coupon', 'shop_webhook', 'bwl_kb' ];
    } else {

        $removed_items = [ 'attachment', 'revision', 'nav_menu_item', 'product_variation', 'shop_order', 'shop_order_refund', 'shop_coupon', 'shop_webhook', 'bwl_kb' ];
    }

    foreach ( $removed_items as $rm_post_types_key => $rm_post_types_vlaue ) {

        foreach ( array_keys( $available_bpvm_post_types, $rm_post_types_vlaue ) as $key ) {
            unset( $available_bpvm_post_types[ $key ] );
        }
    }

    if ( class_exists( 'TribeEvents' ) ) {

        $available_bpvm_post_types = array_merge( [ 'tribe_events' => 'tribe_events' ], $available_bpvm_post_types );
    }

    // Added in version 1.1.4
    // @Date: 14-08-16

    if ( isset( $pvm_data['pvm_additional_cpt'] ) && $pvm_data['pvm_additional_cpt'] != '' ) {

        $pvm_additional_cpt     = [];
        $get_pvm_additional_cpt = explode( ',', $pvm_data['pvm_additional_cpt'] );

        foreach ( $get_pvm_additional_cpt as $key => $value ) {

            $pvm_additional_cpt_id = trim( $value );

            $pvm_additional_cpt[ $pvm_additional_cpt_id ] = $pvm_additional_cpt_id;
        }

        if ( is_array( $pvm_additional_cpt ) && sizeof( $pvm_additional_cpt ) > 0 ) {

            $available_bpvm_post_types = array_merge( $pvm_additional_cpt, $available_bpvm_post_types );
        }
    }

    return $available_bpvm_post_types;
}


// Plugin remove custom columns from "removed" post types.

function bpvm_admin_filter_cpt( $available_bpvm_post_types ) {

    $pvm_data = get_option( 'bwl_pvm_options' );

    if ( isset( $available_bpvm_post_types ) && sizeof( $available_bpvm_post_types ) > 0 ) {

        foreach ( $available_bpvm_post_types as $post_type_key => $value ) {

            $opt_post_type_key = 'pvmpt_' . $post_type_key;

            if ( isset( $pvm_data[ $opt_post_type_key ] ) && $pvm_data[ $opt_post_type_key ] != 1 ) {

                unset( $available_bpvm_post_types[ $post_type_key ] );
            }
        }
    }

    return $available_bpvm_post_types;
}

function bpvm_get_all_post_types() {

    if ( class_exists( 'TribeEvents' ) ) {

        $bpvm_default_post_types = [ 'post' => 'post', 'tribe_events' => 'tribe_events' ];
    } else {

        $bpvm_default_post_types = [ 'post' => 'post' ];
    }

    $bpvm_custom_post_types = array_merge( $bpvm_default_post_types, bpvm_clean_custom_post_types() );

    return $bpvm_custom_post_types;
}

function bpvm_get_custom_column_post_types() {

    if ( class_exists( 'TribeEvents' ) ) {

        $bpvm_default_post_types = [ 'posts' => 'posts', 'tribe_events' => 'tribe_events' ];
    } else {

        $bpvm_default_post_types = [ 'post' => 'post' ];
    }

    $bpvm_custom_post_types = array_merge( $bpvm_default_post_types, bpvm_clean_custom_post_types() );

    return $bpvm_custom_post_types;
}

function bpvm_get_widget_custom_post_types() {

    $bpvm_default_post_types = [ 'post' => 'post' ];

    $bpvm_custom_post_types = array_merge( $bpvm_default_post_types, bpvm_clean_custom_post_types() );

    return $bpvm_custom_post_types;
}

function bpvm_change_date_format( $custom_date ) {

    if ( empty( $custom_date ) ) {
        return $custom_date;
    } else {

        $explode_custom_date = explode( '/', $custom_date );
        return $explode_custom_date[1] . '/' . $explode_custom_date[0] . '/' . $explode_custom_date[2];
    }
}
