<?php
use BPVMWP\Callbacks\Pages\PluginInfoCb;

/**
 * Add the menu page for the plugin.
 *
 * @since 1.0.0
 */
function bpvm_menu_page_cb() {

    $plugin_info_cb = new PluginInfoCb();

    add_menu_page(
        esc_html__( 'Voting Manager Option Panel', 'bwl-pro-voting-manager' ),
        esc_html__( 'Voting Manager', 'bwl-pro-voting-manager' ),
        'manage_options',
        BPVM_ADMIN_PARENT_MENU_SLUG,
        [ $plugin_info_cb, 'load_template' ], // Settings Page
        BPVM_PLUGIN_LIBS_DIR . 'images/bpvm_menu_icon.png'
    );
}

add_action( 'admin_menu', 'bpvm_menu_page_cb' );
