<?php
// phpcs:ignoreFile
/**
 * Plugin Voting Report Page Template
 *
 * @package BPVMWP
 */
?>
<div class="wrap bpvm-filter-wrapper" id="pvm_voting_report_page">

  <h2><?php esc_html_e("Voting Report:", "bwl-pro-voting-manager"); ?>
    <span id="bpvm-admin-loader" class="dn"><?php esc_html_e("Processing....", "bwl-pro-voting-manager"); ?></span>
  </h2>


  <div class="notice notice-info">
    <p class="bwl_plugins_notice_text">
      <strong class="bwl_plugins_notice_text--darkblue"><span class="dashicons dashicons-superhero-alt"></span>
        <?php esc_html_e("Tips:", "bwl-pro-voting-manager"); ?></strong>
      <?php esc_html_e("To remove voting data, select", "bwl-pro-voting-manager"); ?> <strong
        class="bwl_plugins_notice_text--success">"<?php esc_html_e("Details", "bwl-pro-voting-manager"); ?>"</strong>
      <?php esc_html_e("from the", "bwl-pro-voting-manager"); ?> <strong
        class="bwl_plugins_notice_text--success">"<?php esc_html_e("Info Type:", "bwl-pro-voting-manager"); ?>"</strong>
      <?php esc_html_e("drop-down", "bwl-pro-voting-manager"); ?>.
    </p>
  </div>

  <div class="ctrl-section">

    <form method="post" action="" enctype="multipart/form-data" id="bpvm-report-filter-form"
      class="bpvm-report-filter-form">

      <?php wp_nonce_field(BPVM_ADMIN_NONCE_ID, 'report_nonce'); ?>

      <div class="bpvm-report-filter-form__filters">

        <div class="bpvm-report-filter-form__filters--post-types">
          <span class="report-filter-title"><?php esc_html_e("Post Types", "bwl-pro-voting-manager"); ?></span>
          <span class="report-break"></span>
          <select id="mv_bpvm_post_type" name="mv_bpvm_post_type">
            <option value="" selected>- <?php esc_html_e("Select", "bwl-pro-voting-manager"); ?> -</option>
            <?php              

              foreach ($available_bpvm_post_types as $bpvm_post_type_key => $bpvm_post_type_value) :

                $bpvm_post_type_value = strtolower($bpvm_post_type_value);

                $bpvm_post_type_title = ucfirst(str_replace('_', ' ', $bpvm_post_type_value));
              ?>
            <option value="<?php echo $bpvm_post_type_value; ?>"><?php echo $bpvm_post_type_title; ?></option>
            <?php
              endforeach;
              ?>
          </select>
        </div>

        <div class="bpvm-report-filter-form__filters--post-titles">
          <span class="report-filter-title"><?php esc_html_e("Posts", "bwl-pro-voting-manager"); ?></span>
          <span class="report-break"></span>
          <select id="mv_post_title" name="mv_post_title">
            <option value="" selected>- <?php esc_html_e("Select", "bwl-pro-voting-manager"); ?> -</option>
          </select>
        </div>

        <div class="bpvm-report-filter-form__filters--types">
          <span class="report-filter-title"><?php esc_html_e("Filter Types", "bwl-pro-voting-manager"); ?></span>
          <span class="report-break"></span>
          <select id="mv_post_filters" name="mv_post_filters">
            <option value="" selected>- <?php esc_html_e("Select", "bwl-pro-voting-manager"); ?> -</option>
            <option value="1"><?php esc_html_e("Only Likes", "bwl-pro-voting-manager"); ?></option>
            <option value="2"><?php esc_html_e("Only Dislikes", "bwl-pro-voting-manager"); ?></option>
          </select>

        </div>

        <div class="bpvm-report-filter-form__filters--info">

          <span class="report-filter-title"><?php esc_html_e("Info Types", "bwl-pro-voting-manager"); ?></span>
          <span class="report-break"></span>
          <select id="mv_vote_info_type" name="mv_vote_info_type">
            <option value="1" selected="selected"><?php esc_html_e("Summary", "bwl-pro-voting-manager"); ?></option>
            <option value="2"><?php esc_html_e("Details", "bwl-pro-voting-manager"); ?></option>
          </select>
        </div>

        <div class="bpvm-report-filter-form__filters--dates">
          <span class="report-filter-title"><?php esc_html_e("Custom Date Range:", "bwl-pro-voting-manager"); ?></span>
          <input type="checkbox" id="pvm_custom_date_range" name="pvm_custom_date_range" />
          <span class="report-break"></span>
          <input type="text" placeholder="Start" size="10" id="pvm_filter_start_date" name="pvm_filter_start_date" />
          <input type="text" placeholder="End" size="10" id="pvm_filter_end_date" name="pvm_filter_end_date" />
        </div>

      </div>

      <div class="bpvm_report_btns">
        <input type="hidden" name="_wp_http_referer" value="<?php echo $_SERVER['REQUEST_URI'] ?>" />

        <?php

            $report_btns = [
              'mv_pvm_go' => [
                'title' => esc_html__("Generate Report", "bwl-pro-voting-manager"),
                'class' => 'button button-primary button-large',
                'type' => 'button',
              ],
              'pvm_amv' => [
                'title' => esc_html__("Add Manual Votes", "bwl-pro-voting-manager"),
                'class' => 'button button-primary button-large',
                'type' => 'button',
              ],
              'pvm_download_report' => [
                'title' => esc_html__("Download", "bwl-pro-voting-manager"),
                'class' => 'button button-primary button-large',
                'type' => 'submit',
              ],
              'pvm_reset_report' => [
                'title' => esc_html__("Reset", "bwl-pro-voting-manager"),
                'class' => 'button button-primary button-large',
                'type' => 'button',
              ],
            ];

            foreach ($report_btns as $btn_id => $btn_data) {
              $btn_type = $btn_data['type'];
              $btn_title = $btn_data['title'];
              $btn_class = $btn_data['class'];

              echo '<input type="' . $btn_type . '" name="' . $btn_id . '" id="' . $btn_id . '" value="' . $btn_title . '" class="' . $btn_class . '" />';
            }


            ?>
      </div>

    </form>

  </div>

  <table class="nowrap display dn" cellspacing="0" width="100%" id="bpvm-data-table"
    style="text-align: center !important;">
    <thead>
      <tr>
        <th width="2%"><input type="checkbox" id="bpvm_bulkdelete" /><button id="deleteTriger"
            class="button button-primary button-small btn-delete-data">X</button></th>
        <th width="25%"><?php esc_html_e("Date", "bwl-pro-voting-manager"); ?></th>
        <th width="20%"><?php esc_html_e("Type", "bwl-pro-voting-manager"); ?></th>
        <th width="20%"><?php esc_html_e("Count", "bwl-pro-voting-manager"); ?></th>
      </tr>
    </thead>
  </table>


  <div id="pvm-manual-voting-modal" title="<?php esc_html_e("Add Menual Votes", "bwl-pro-voting-manager"); ?>"
    class="dn">

    <p class="message-text dn"></p>

    <!-- start id-form -->

    <div class="pvm-manual-vote-form" id="id-form">
      <div class="pvm-manual-vote-form__row">
        <span class="pvm-manual-vote-form__field_title">
          <?php esc_html_e("Choose Date:", "bwl-pro-voting-manager"); ?>
        </span>
        <input type="text" name="pvm_mv_date" id="pvm_mv_date" value=""
          class="input-box large-input-box rounded-corner" />
      </div>

      <div class="pvm-manual-vote-form__row">
        <span class="pvm-manual-vote-form__field_title">
          <?php esc_html_e("Vote Type:", "bwl-pro-voting-manager"); ?>
        </span>

        <select name="pvm_mv_vote_type" id="pvm_mv_vote_type" class="pvm_mv_vote_type">
          <option value=""><?php esc_html_e("Select", "bwl-pro-voting-manager"); ?></option>
          <option value="1"><?php esc_html_e("Like", "bwl-pro-voting-manager"); ?></option>
          <option value="2"><?php esc_html_e("Dislike", "bwl-pro-voting-manager"); ?></option>
        </select>
      </div>

      <div class="pvm-manual-vote-form__row">
        <span class="pvm-manual-vote-form__field_title">
          <?php esc_html_e("Add Manual Votes:", "bwl-pro-voting-manager"); ?>
        </span>
        <input type="text" name="pvm_manual_votes" id="pvm_manual_votes" value="" class="input-box-small" /> (e.g:
        1,2,3)
      </div>
    </div>

  </div>

  <div id="pvm-delete-voting-modal" title="<?php esc_html_e("Delete Votes", "bwl-pro-voting-manager"); ?>" class="dn">

    <p class="message-text dn"></p>

    <p>
      <em><?php esc_html_e("Caution: Data will be deleted permanently.", "bwl-pro-voting-manager"); ?></em>
    </p>

    </table>

  </div>
</div>
