<?php
/**
 * License Verify Offline Form Template
 *
 * @package BPVMWP
 */
// phpcs:ignoreFile
?>
<div class="license_form_container">
  <h3>Activate plugin license to unlock premium features and official support.</h3>

  <?php

	if ( $verification_type === 'offline' ) {

			$msg = '';

		if ( isset( $_POST['offline_verification'] ) &&
			$_POST['offline_verification'] === 'offline_code' &&
			! empty( $_POST['bwlofflinecode'] ) ) {

			$offline_code      = sanitize_text_field( $_POST['bwlofflinecode'] );
			$decodeOfflineCode = base64_decode( $offline_code );

			$explode_purchase_info = explode( '|', $decodeOfflineCode );

			$msg = esc_html__( 'Invalid offline code!', 'bwl-pro-voting-manager' );

			if ( count( $explode_purchase_info ) > 1 ) {

				$purchaseData = [];

				foreach ( $explode_purchase_info as $data ) {

					list($tag, $value) = explode( '=', $data );

					$purchaseData[ $tag ] = $value;
				}

				if ( isset( $purchaseData['item'] ) && BPVM_PRODUCT_ID === $purchaseData['item'] ) {
					delete_option( BPVM_PURCHASE_VERIFIED_KEY );
					delete_option( BPVM_PURCHASE_INFO_KEY );

					update_option( BPVM_PURCHASE_VERIFIED_KEY, '1' );
					update_option( BPVM_PURCHASE_INFO_KEY, $purchaseData );

					header( 'Location: ' . get_admin_url() . BPVM_PRODUCT_LICENSE_PAGE );
					exit();
				}
			}
		} else {
			$msg = esc_html__( 'Please enter the offline code!', 'bwl-pro-voting-manager' );
		}

		?>
  <h3><?php esc_html_e( 'Offline Verification', 'bwl-pro-voting-manager' ); ?>:</h3>

  <?php echo ( ! empty( $msg ) ) ? "<p class='offline-msg'>$msg</p>" : ''; ?>

  <form method="post" action="#" action="<?php echo esc_url( admin_url( BPVM_PRODUCT_LICENSE_PAGE_OFFLINE ) ); ?>"
    id="bpvm_offline_verify_purchase">
    <input type="hidden" name="offline_verification" value="offline_code"><textarea id="bwlofflinecode"
      name="bwlofflinecode" value=""
      placeholder="<?php esc_html_e( 'Enter offline verification code here.', 'bwl-pro-voting-manager' ); ?>" cols="60"
      rows="4"></textarea>
    <input type="submit" value="<?php esc_html_e( 'Active License', 'bwl-pro-voting-manager' ); ?>"
      class="button button-primary" id="offline_verify">
  </form>

  <p>
    <strong>I have the </strong><a href="<?php echo esc_url( admin_url( BPVM_PRODUCT_LICENSE_PAGE ) ); ?>">purchase
      code</a>.
  </p>

  <?php
	}

	?>

  <p>
    <strong><?php esc_html_e( 'Do you need offline verification code or any help?', 'bwl-pro-voting-manager' ); ?></strong>
    <a href="<?php echo BPVM_PRODUCT_SUPPORT; ?>" target="_blank">
      <?php esc_html_e( 'Send a message', 'bwl-pro-voting-manager'); ?></a>.
  </p>


</div>
