<?php
/**
 * License Information Template
 *
 * @package BPVMWP
 */
// phpcs:ignoreFile
use BPVMWP\Helpers\BpvmHelper;
$purchase_info        = $license_data['info'];
$support_renwal_info  = BpvmHelper::get_renewal_days_left( $purchase_info['supported_until'] );
$support_renwal_class = intval( $support_renwal_info['msg'] ) === 1 ? 'support-valid' : 'support-expired';
?>
<div class="license_info_container">
  <h3>License Information:</h3>

  <ul class="plugin_purchase_info">
    <li><strong>License Type:</strong> <span><?php echo esc_html( $purchase_info['license'] ); ?></span></li>
    <li><strong>Purchase Date:</strong>
      <span><?php echo BpvmHelper::beautify_date( $purchase_info['sold_at'] ); ?></span>
    </li>
    <li><strong>Support Until:</strong>
      <span><?php echo BpvmHelper::beautify_date( $purchase_info['supported_until'] ); ?></span>
      <span class="<?php echo $support_renwal_class; ?>"><?php echo esc_html( $support_renwal_info['msg'] ); ?></span>
    </li>
  </ul>

  <button id="bpvm_remove_license" class="button button-primary"
    data-verify_hash="<?php echo $purchase_info['verify_hash']; ?>">Remove License</button>

  <?php if ( BpvmHelper::get_renewal_days_left( $purchase_info['supported_until'] )['status'] == 0 ) : ?>
  <a href="<?php echo BPVM_PRODUCT_URL; ?>" class="button button-primary" target="_blank">Renew License</a>
  <?php endif; ?>

</div>
