<?php
// phpcs:ignoreFile
/**
 * The template for displaying plugin addons list.
 *
 * @package BwlKbManager
 * @since 1.0.0
 */
?>

<div class="wrap bpvm-addon-page-wrap" id="bpvm-addon-page-wrap">

  <h2><?php echo esc_html( $page_title ); ?></h2>

  <div class="bwl-plugin-grid bwl-plugin-grid--cols-3">

    <?php
    foreach ( $addons as $addon ) :

    $title = $addon['title'] ?? '';
		$preview   = $addon['preview'] ?? '';
		$download  = $addon['download'] ?? '';
		$doc       = $addon['doc'] ?? '';
        ?>

    <div class="bwl-product-card">

      <?php

		if ( ! empty( $preview ) ) {
            printf( '<a href="%s" target="_blank"><img src="%s" alt="%s"></a>', esc_html( $download ), esc_html( $preview ), esc_html( $title ) );
        }

        echo '<div class="bwl-product-card__btn-container">';
        printf('<a href="%s" target="_blank"
          class="bwl-product-card__button bwl-product-card__button--download">%s</a>', esc_html( $download ), esc_html__( 'Download', 'bwl-adv-faq' ));
        printf('<a href="%s" target="_blank"
          class="bwl-product-card__button bwl-product-card__button--documentation">%s</a>', esc_html( $doc ), esc_html__( 'Documentation', 'bwl-adv-faq' ));
		echo '</div>';
		?>

    </div>
    <?php endforeach ?>

  </div>

</div>
