<?php
namespace BPVMWP\Traits;

trait LicenseTraits {

	/**
     * Get the license FAQs.
     */
	public function get_license_faqs() {

		$faqs = [
			[
				'ques' => 'How to download the purchase code?',
				'ans'  => "Check <a href=' https://bluewindlab.net/knowledgebase/general/where-i-can-get-the-purchase-code/' target='_blank'>this article</a> for step-by-step instructions.",
			],

			[
				'ques' => 'I downloaded the plugin from Envato Elements. How can I get the purchase code?',
				'ans'  => 'Unfortunately, you can not. However, you can use all the features of the plugin without issue. The only exception is that we do not provide customer support if you download the plugin from Envato Elements.',
			],
			[
				'ques' => 'Can I get customer support If I download the plugin from Envato Elements?',
				'ans'  => "No. To get the author's premium support, please consider purchasing the plugin from <a href='" . BPVM_PRODUCT_URL . "' target='_blank'>CodeCanYon</a>.",
			],
			[
				'ques' => 'My six-month premium support period has expired. How to extend it?',
				'ans'  => "Follow <a href='" . BPVM_PRODUCT_URL . "' target='_blank'>this link</a> and click the Renew Support button.",
			],
		];

		return $faqs;
	}

	/**
     * Get the license information.
     */
	public function get_license_info() {

		$status = get_option( BPVM_PURCHASE_VERIFIED_KEY ) ?? 0;
		$info   = get_option( BPVM_PURCHASE_INFO_KEY ) ?? [];

		$data = [
			'title'       => BPVM_PLUGIN_TITLE,
			'status'      => $status, // 1= active, 0=not active, 2=no license reqruired.
			'info'        => $info,
			'pluginId'    => BPVM_PRODUCT_ID,
			'supportLink' => BPVM_PRODUCT_SUPPORT,
		];

		return $data;
	}
}
