<?php
namespace BPVMWP\Traits;

trait CommonTraits {
	/**
	 * Get the youtube video link.
	 *
	 * @param string $link the youtube video link.
 	 * @param string $title the title of the link.
	 *
	 * @return string
	 */
	public static function set_youtube_url( $link = '', $title = 'video tutorial' ): string {

		if ( empty( $link ) ) {
			return '';
		}

		$icon = "<span class='dashicons dashicons-youtube'></span>";
		$link = esc_url( $link );

		return "<a href={$link} title={$title} class='bwl_youtube_link' target='_blank'>{$icon}</a>";
	}
}
