<?php
namespace BPVMWP\Helpers;

use BPVMWP\Helpers\LoggedInStatusChecker;
use BPVMWP\Helpers\SingleVoteStatusChecker;
use BPVMWP\Helpers\CategoryWiseVoteStatusChecker;

/**
 * Class for Vote Status Checker.
 *
 * @package BPVMWP
 */
class VoteStatusChecker {

    /**
     * Check if user already voted or not. It check by IP address and time interval settings.
     *
     * @param int $post_id The post ID.
     *
     * @return bool
     */
    public static function has_user_already_voted( $post_id ) {

        // Get all plugin options.
        $bwl_pvm_options = PluginConstants::$plugin_options;

        // status
        // 0 = not voted yet.
        // 1 = Already voted.
        // 2 = Limit Crossed.
        /*--- IP Filter Status ---*/

        $pvm_vote_checking_result = [];

        // Messages.

        $pvm_msg_thanks        = apply_filters( 'pvm_msg_thanks', esc_html__( 'Thanks for your vote!', 'bwl-pro-voting-manager' ) );
        $pvm_msg_limit_crossed = apply_filters( 'pvm_msg_limit_cross', esc_html__( 'Voting Limit Crossed!', 'bwl-pro-voting-manager' ) );
        $pvm_msg_vote_exist    = apply_filters( 'pvm_msg_vote_exist', esc_html__( 'You have already submitted your vote!', 'bwl-pro-voting-manager' ) );

        // Retrieve current user IP
        $ip = $_SERVER['REMOTE_ADDR'];
        // $ip = MY_TEST_IP; // remove later.

        // Interval before submit another vote.
        // @param: Default Interval = 2 hours (120 minutes)
        $timebeforerevote = ( isset( $bwl_pvm_options['pvm_vote_interval'] ) && is_numeric( $bwl_pvm_options['pvm_vote_interval'] ) ) ? $bwl_pvm_options['pvm_vote_interval'] : 120;

        // $pvm_max_vote_submission = ( isset($bwl_pvm_options['pvm_max_vote_submission'] ) && is_numeric( $bwl_pvm_options['pvm_max_vote_submission'] ) ) ? $bwl_pvm_options['pvm_max_vote_submission'] : 1; // = 1 votes.

        // Get the share button display status.
        // @param: Default: Yes.
        $bpvm_share_btn = ( isset( $bwl_pvm_options['pvm_disable_share_button'] ) && $bwl_pvm_options['pvm_disable_share_button'] == 1 ) ? '' : do_shortcode( '[bpvm_share post_id=' . $post_id . ' /]' );

        // Get the IP filter status. If filter is turned ON, the user can submit 1 vote within 120 minutes interval.
        $pvm_ip_filter_status = ( isset( $bwl_pvm_options['pvm_ip_filter_status'] ) && $bwl_pvm_options['pvm_ip_filter_status'] == 1 ) ? 1 : 0;

        $bpvm_vote_once_status = ( isset( $bwl_pvm_options['bpvm_vote_once_status'] ) && $bwl_pvm_options['bpvm_vote_once_status'] == 1 ) ? 1 : 0;

        $loginStatus = ( isset( $bwl_pvm_options['pvm_login_status'] ) && $bwl_pvm_options['pvm_login_status'] == 1 ) ? 1 : 0;

        $restrictCategoryWiseVoting = ( isset( $bwl_pvm_options['bpvm_category_wise_vote_status'] ) && $bwl_pvm_options['bpvm_category_wise_vote_status'] == 1 ) ? 1 : 0;

        // Restrict one vote per each category.

        if ( $restrictCategoryWiseVoting == 1 && $loginStatus == 1 ) {

            $pvm_vote_checking_result = CategoryWiseVoteStatusChecker::restrict_category_wise_voting( $bpvm_share_btn, $post_id, $pvm_msg_thanks );

            return $pvm_vote_checking_result;
        }

        // Only one vote for the entire site.

        if ( $pvm_ip_filter_status == 1 && $bpvm_vote_once_status == 1 ) {

            $pvm_vote_checking_result = SingleVoteStatusChecker::check_vote_once_status( $bpvm_share_btn, $pvm_msg_thanks );

            return $pvm_vote_checking_result;
        }

        // A logged-in user can submit only one vote for a post.

        if ( $loginStatus == 1 ) {

            $pvm_vote_checking_result = LoggedInStatusChecker::check_logged_in_user_vote_status( $bpvm_share_btn, $post_id, $pvm_msg_thanks );

            return $pvm_vote_checking_result;
        }

        // Retrieve the voted IP's for the post

        $like_vote_counter    = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
        $dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

        if ( ( $like_vote_counter == '' || $like_vote_counter == 0 ) && ( $dislike_vote_counter == '' || $dislike_vote_counter == 0 ) ) {

            $pvm_vote_checking_result = [
                'status'            => 0, // You can submit vote
                'pvm_clear_counter' => 0,
                'msg'               => $pvm_msg_thanks . $bpvm_share_btn,
            ];

            return $pvm_vote_checking_result;
        }

        /*--- End Submission Counter Checking ---*/

        // tag = pvm_once_13_05_2017_10_10_20_2217

        // If user has already voted
        if ( $pvm_ip_filter_status == 1 ) {

            /*--- Start Submission Counter Checking ---*/

            $pvm_limit_cross_status = BpvmHelper::check_vote_limit_cross_status( $post_id );

            /*--- Start User IP Checking ---*/

            $meta_IP = get_post_meta( $post_id, 'pvm_voted_ip' );

            if ( is_array( $meta_IP ) && ! empty( $meta_IP[0] ) ) {

                $voted_IP = $meta_IP[0];
            } else {

                $voted_IP = [];
            }

            $time = $voted_IP[ $ip ];

            $now = time();

            if ( round( ( $now - $time ) / 60 ) > $timebeforerevote ) {

                // Erase old limit cross counter.

                $pvm_vote_checking_result = [
                    'status'            => 0, // You can submit vote,
                    'pvm_clear_counter' => 1,
                    'msg'               => $pvm_msg_thanks . $bpvm_share_btn,
                ];
            } elseif ( round( ( $now - $time ) / 60 ) <= $timebeforerevote && $pvm_limit_cross_status == false ) {

                // You can submit vote and return thank you message.

                $pvm_vote_checking_result = [
                    'status'            => 0, // You can submit vote
                    'pvm_clear_counter' => 0,
                    'msg'               => $pvm_msg_thanks . $bpvm_share_btn,
                ];
            } elseif ( $pvm_limit_cross_status == true ) {

                // time available for vote but limit crossed.

                $pvm_vote_checking_result = [
                    'status'            => 2, // Voting Limit Crossed.
                    'pvm_clear_counter' => 0,
                    'msg'               => $pvm_msg_limit_crossed,
                ];
            } else {

                $pvm_vote_checking_result = [
                    'status'            => 1,
                    'pvm_clear_counter' => 0,
                    'msg'               => $pvm_msg_vote_exist,
                ];
            }
        } else {

            // Default.
            // You can submit vote and return thank you message.

            $pvm_vote_checking_result = [
                'status'            => 0, // You can submit vote
                'pvm_clear_counter' => 0,
                'msg'               => $pvm_msg_thanks . $bpvm_share_btn,
            ];
        }

        /*--- End User IP Checking ---*/

        return $pvm_vote_checking_result;
    }
}
