<?php
namespace BPVMWP\Helpers;

/**
 * Class for Single Vote Status Checker.
 *
 * @package BPVMWP
 */
class SingleVoteStatusChecker {


	/**
     * Check if the user has already voted once.
     *
	 * @param  mixed  $bpvm_share_btn Share button HTML.
	 * @param  string $pvm_msg_thanks Thank you message.
	 * status=1 (Already voted), status=0 (Not voted yet)
	 * pvm_clear_counter=1 (remove the old vote counter), pvm_clear_counter=0 (keep the old counter)
	 * @return array ['status', 'pvm_clear_counter', 'msg']
	 */
	public static function check_vote_once_status( $bpvm_share_btn, $pvm_msg_thanks = '' ) {

		// Here we will get all the once voted info as an array.
		// ID PATTERN: 'pvm_once_pvm_user_ip_pvm_vote_date'

		$singleVoteInfo = get_option( 'pvm_once_voted_info' );

		$userIP   = $_SERVER['REMOTE_ADDR'];
		$voteDate = date_i18n( 'Y-m-d', false, true );

		$singleVoteTrackingId = 'pvm_once_' . $userIP . '_' . $voteDate;

		if ( isset( $singleVoteInfo[ $voteDate ] )
        && in_array( $singleVoteTrackingId, array_keys( $singleVoteInfo[ $voteDate ] ) )
		) {

			// echo "Already voted."

			$singleVoteSubmissionStatus = [
				'status'            => 1,
				'pvm_clear_counter' => 0,
				'msg'               => apply_filters( 'pvm_msg_single_vote', esc_html__( ' You are only allowed to vote for just one post per day!', 'bwl-pro-voting-manager' ) ),
			];
		} else {

			// echo "Not voted yet.";
			$singleVoteInfo[ $voteDate ][ $singleVoteTrackingId ] = 'true';
			update_option( 'pvm_once_voted_info', $singleVoteInfo );

			$singleVoteSubmissionStatus = [
				'status'            => 0,
				'pvm_clear_counter' => 1,
				'msg'               => $pvm_msg_thanks . $bpvm_share_btn,
			];
		}

		return $singleVoteSubmissionStatus;
	}
}
