<?php
namespace BPVMWP\Helpers;

/**
 * Class for the plugin color scheme.
 *
 * We will use this both frontend and backend.
 *
 * @package BPVMWP
 */
class PluginColorScheme {

	/**
	 * Plugin color scheme.
	 *
	 * @var array
	 */
	public static $color_scheme = [];

	/**
	 * Register the color scheme.
	 */
	public function register() {

			$this->set_color_scheme();
	}


	/**
	 * Set the color scheme.
	 *
	 * @return void
	 */
	public function set_color_scheme() {

		$color_scheme = [
			'like_thumb_color'             => '#1E73BE',
			'like_thumb_bg_color'          => '#FFFFFF',
			'like_thumb_hover_color'       => '#1E73BE',
			'like_thumb_hover_bg_color'    => '#F2F2F2',
			'dislike_thumb_color'          => '#FF4828',
			'dislike_thumb_bg_color'       => '#FFFFFF',
			'dislike_thumb_hover_color'    => '#FF4828',
			'dislike_thumb_hover_bg_color' => '#F2F2F2',
			'like_bar_color'               => '#1E73BE',
			'dislike_bar_color'            => '#FF4828',
			'tipsy_bg'                     => '#000000',
			'tipsy_text_color'             => '#FFFFFF',
		];

		self::$color_scheme = $color_scheme;

	}
}
