<?php
namespace BPVMWP\Helpers;

use BPVMWP\Callbacks\Actions\Admin\Scheduler\ProductsSchedulerCb;

/**
 * Class for common helper functions
 *
 * @package BPVMWP
 */
class OurProducts {

    /**
	 * Get the products data.
	 *
	 * @return array
	 */
	public static function get_products() {

		$our_products = get_option( BPVM_CRON_BWL_PRODUCTS_OPTION_ID ) ?? [];

		if ( empty( $our_products ) ) {
			$our_products = ( new ProductsSchedulerCb() )->fetch_api_data( true );
		}

		$general       = [];
		$wp_plugins    = [];
		$wp_themes     = [];
		$html_template = [];

		if ( ! empty( $our_products ) ) {
			foreach ( $our_products['data'] as $product ) {
				switch ( $product['tag'] ) {
					case 'wp-plugin':
						$wp_plugins[] = $product;
						break;
					case 'wp-theme':
						$wp_themes[] = $product;
						break;
					case 'html-template':
						$html_template[] = $product;
						break;
					default:
						$general[] = $product;
						break;
				}
			}
		}

		$data = [
			'wp_plugins'    => $wp_plugins,
			'wp_themes'     => $wp_themes,
			'html_template' => $html_template,
			'general'       => $general,
		];

		return $data;
	}
}