<?php
namespace BPVMWP\Helpers;

/**
 * Class for common helper functions
 *
 * @package BPVMWP
 */
class Common {

    /**
     * Make user voting date more human friendly.
     *
     * @param string $date the date.
     * @return array
     */
	public static function human_date_format( $date ) {

		$date_info = explode( ' ', $date );

		if ( count( $date_info ) === 2 ) {

			// With Time Info.
			$final_date_info = explode( '-', $date_info[0] );
			$time_info       = ' ' . $date_info[1];
		} else {

			// Without Time Info.
			$final_date_info = explode( '-', $date_info[0] );
			$time_info       = '';
		}

		return $final_date_info[2] . '-' . $final_date_info[1] . '-' . $final_date_info[0] . $time_info;
	}

    /**
     * Get the BWL API URL.
     *
     * @return string
     */
	public static function bwl_api_url() {
		$baseUrl = get_home_url();
		if ( preg_match( '/(localhost|\.local)/', $baseUrl ) ) {
			return 'http://bwlapi.local/';
		}  elseif ( strpos( $baseUrl, 'staging.bluewindlab.com' ) != false ) {
			return 'https://staging.bluewindlab.com/bwl_api/';
		} else {
			return 'https://api.bluewindlab.net/';
		}
	}
}
