<?php
namespace BPVMWP\Helpers;

/**
 * Class for common admin helpers.
 *
 * @package BPVMWP
 */
class AdminHelpers {

    /**
     * BPVotingManager reset voting data.
     *
     * @param string $post_type the post type.
     * @param int    $post_id   the post ID.
     * @param string $vote_type the vote type.
     *
     * @return string
     */
    public static function bpvm_reset_voting_data( $post_type = '', $post_id = 0, $vote_type = '' ) {

        if ( $post_id == 0 || empty( $post_type ) || empty( $vote_type ) ) {
            return '';
        } else {

            // Run Row Deletion Query.

            global $wpdb;
            $data_table    = TABLE_BPVM_DATA;
            $summary_table = TABLE_BPVM_SUMMARY;

            // Delete Details Table Data.

            $wpdb->delete(
                $data_table,
                [ 'post_type' => $post_type, 'postid' => $post_id, 'vote_type' => $vote_type ],
                [ '%s', '%d', '%d' ] // Where Format
            );

            // Update summary table.
            $is_row_exist = $wpdb->get_results( "SELECT ID FROM $summary_table WHERE postid= '" . $post_id . "' AND vote_type= '" . $vote_type . "'" );

            if ( count( $is_row_exist ) > 0 ) {
                // Update Row
                $wpdb->delete(
                    $summary_table,
                    [ 'post_type' => $post_type, 'postid' => $post_id, 'vote_type' => $vote_type ],
                    [ '%s', '%d', '%d' ] // Where Format
                );
            }

            // Update total votes info.
            // Added in version 1.1.5

            $like_vote_counter    = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );
            $dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

            $total_vote_counter = $like_vote_counter + $dislike_vote_counter;

            update_post_meta( $post_id, BPVM_TOTAL_VOTES, $total_vote_counter );

            wp_reset_postdata();
        }
    }

    /**
	 * Set YouTube URL.
     *
	 * @param string $link get the YouTube url.
	 * @param string $title set custom title for the YouTube video.
	 */
	public static function set_youtube_url( $link = '', $title = 'video tutorial' ) {

		if ( empty( $link ) ) {
			return '';
		}

		$icon = "<span class='dashicons dashicons-youtube'></span>";

		return sprintf(
			'<a href="%s" title="%s" class="bwl_youtube_link" target="_blank">%s</a>',
			esc_url( $link ),
			esc_attr( $title ),
			$icon
		);
	}
}