<?php
namespace BPVMWP\Helpers;

/**
 * Class for BPVM Addons helper functions
 *
 * @package BPVMWP
 */
class AddonsHelper {

	/**
	 * Get the status of the addon.
	 *
	 * @param string $addonPath The path of the addon.
	 *
	 * @return int 1 if the addon is active, 0 otherwise.
	 */
	public static function get_status( $addonPath = '' ) {

		$status = ! empty( in_array( $addonPath, apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ); //phpcs:ignore.
		return $status ? 1 : 0;
	}


	/**
	 * Get the activation status of the addon.
	 *
	 * @param string $addon The addon key.
	 *
	 * @return int 1 if the addon is active, 0 otherwise.
	 */
	public static function get_activation_status( $addon = '' ) {

		switch ( $addon ) {

			case 'umvaddon':
				return self::get_status( 'bpvm-undo-my-vote-addon/bpvm-undo-my-vote-addon.php' );

			case 'recapaddon':
				return self::get_status( 'bpvm-recaptcha-addon/bpvm-recaptcha-addon.php' );

			case 'wpvaaddon':
				return self::get_status( 'woocommerce-product-voting-addon/woocommerce-product-voting-addon.php' );

			case 'uvtaddon':
				return self::get_status( 'user-vote-tracker/user-vote-tracker.php' );

			default:
				return 0; // Default status if the addon key doesn't match.

		}

	}
}
