<?php
namespace BPVMWP\Controllers\Shortcodes;

use Xenioushk\BwlPluginApi\Api\Shortcodes\ShortcodesApi;
use BPVMWP\Callbacks\Shortcodes\VoteStatsCb;

/**
 * Class VoteStats
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class VoteStats {
	/**
	 * Register the shortcodes.
	 *
	 * @since: 1.1.1
	 */
	public function register() {

		// Initialize API.
		$shortcodes_api = new ShortcodesApi();

		// Initialize callbacks.
		$vote_stats_cb = new VoteStatsCb();

		$shortcodes = [
			[
				'tag'      => 'bpvm_stat',
				'callback' => [ $vote_stats_cb, 'get_the_output' ],
			],
		];

		$shortcodes_api->add_shortcodes( $shortcodes )->register();
	}
}
