<?php
namespace BPVMWP\Controllers\Shortcodes;

use Xenioushk\BwlPluginApi\Api\Shortcodes\ShortcodesApi;
use BPVMWP\Callbacks\Shortcodes\VoteResultsCb;

/**
 * Class VoteResults
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class VoteResults {
	/**
	 * Register the shortcodes.
	 *
	 * @since: 1.1.1
	 */
	public function register() {

		// Initialize API.
		$shortcodes_api = new ShortcodesApi();

		// Initialize callbacks.
		$posts_filter_cb = new VoteResultsCb();

		$shortcodes = [
			[
				'tag'      => 'bpvm_results',
				'callback' => [ $posts_filter_cb, 'get_the_output' ],
			],
		];

		$shortcodes_api->add_shortcodes( $shortcodes )->register();
	}
}
