<?php
namespace BPVMWP\Controllers\Shortcodes;

use Xenioushk\BwlPluginApi\Api\Shortcodes\ShortcodesApi;
use BPVMWP\Callbacks\Shortcodes\VoteLayoutCb;

/**
 * Class VoteLayout
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class VoteLayout {
	/**
	 * Register the shortcodes.
	 *
	 * @since: 1.1.1
	 */
	public function register() {

		// Initialize API.
		$shortcodes_api = new ShortcodesApi();

		// Initialize callbacks.
		$vote_stats_cb = new VoteLayoutCb();

		$shortcodes = [
			[
				'tag'      => 'bwl_pvm',
				'callback' => [ $vote_stats_cb, 'get_the_output' ],
			],
		];

		$shortcodes_api->add_shortcodes( $shortcodes )->register();
	}
}
