<?php
namespace BPVMWP\Controllers\Shortcodes;

use Xenioushk\BwlPluginApi\Api\Shortcodes\ShortcodesApi;
use BPVMWP\Callbacks\Shortcodes\TaxonomyFilterCb;

/**
 * Class TaxonomyFilter
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class TaxonomyFilter {
	/**
	 * Register the shortcodes.
	 *
	 * @since: 1.1.1
	 */
	public function register() {

		// Initialize API.
		$shortcodes_api = new ShortcodesApi();

		// Initialize callbacks.
		$taxonomy_filter_cb = new TaxonomyFilterCb();

		$shortcodes = [
			[
				'tag'      => 'pvm_taxonomy_filter',
				'callback' => [ $taxonomy_filter_cb, 'get_the_output' ],
			],
		];

		$shortcodes_api->add_shortcodes( $shortcodes )->register();
	}
}
