<?php
namespace BPVMWP\Controllers\Shortcodes;

use Xenioushk\BwlPluginApi\Api\Shortcodes\ShortcodesApi;
use BPVMWP\Callbacks\Shortcodes\ShareBtnCb;

/**
 * Class ShareBtn
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class ShareBtn {
	/**
	 * Register the shortcodes.
	 *
	 * @since: 1.1.1
	 */
	public function register() {

		// Initialize API.
		$shortcodes_api = new ShortcodesApi();

		// Initialize callbacks.
		$share_btn_cb = new ShareBtnCb();

		$shortcodes = [
			[
				'tag'      => 'bpvm_share',
				'callback' => [ $share_btn_cb, 'get_the_output' ],
			],
		];

		$shortcodes_api->add_shortcodes( $shortcodes )->register();
	}
}
