<?php
namespace BPVMWP\Controllers\PluginMeta;

/**
 * Class displays options panel, addons, documentation links below the plugin information.
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class MetaInfo {

	/**
	 * Register meta links.
	 */
	public function register() {
		add_filter( 'plugin_row_meta', [ $this, 'get_meta_links' ], null, 2 );
	}

	/**
	 * Filters the plugin action links.
	 *
	 * @param array  $links An array of plugin action links.
	 * @param string $file  The path to the plugin file.
	 *
	 * @return array Filtered array of plugin action links.
	 */
	public function get_meta_links( $links, $file ) {

		if ( strpos( $file, BPVM_PLUGIN_ROOT_FILE ) !== false && is_plugin_active( $file ) ) {

			// nt = 1 // new tab.

			$additional_links = [

				[
					'title' => '🛠️ ' . esc_html__( 'Options', 'bwl-pro-voting-manager' ),
					'url'   => BPVM_ADMIN_OPTIONS_PANEL_URL,
				],
				[
					'title' => '📊 ' . esc_html__( 'Report', 'bwl-pro-voting-manager' ),
					'url'   => BPVM_ADMIN_REPORT_PANEL_URL,
				],
				[
					'title' => '🧩 ' . esc_html__( 'Addons', 'bwl-pro-voting-manager' ),
					'url'   => BPVM_ADMIN_ADDONS_URL,
				],
				[
					'title' => '📘 ' . esc_html__( 'Documentation', 'bwl-pro-voting-manager' ),
					'url'   => BPVM_PRODUCT_DOC,
					'nt'    => 1,
				],
				[
					'title' => '🛟 ' . esc_html__( 'Support', 'bwl-pro-voting-manager' ),
					'url'   => BPVM_PRODUCT_SUPPORT,
					'nt'    => 1,
				],
				[
					'title' => '🎬 ' . esc_html__( 'Tutorials', 'bwl-pro-voting-manager' ),
					'url'   => BPVM_PRODUCT_YOUTUBE_PLAYLIST,
					'nt'    => 1,
				],

			];

			$new_links = [];

			foreach ( $additional_links as $alData ) {

				$newTab = isset( $alData['nt'] ) ? 'target="_blank"' : '';
				$class  = isset( $alData['class'] ) ? 'class="' . $alData['class'] . '"' : '';

				$new_links[] = '<a href="' . esc_url( $alData['url'] ) . '"  ' . $newTab . '  ' . $class . '>' . $alData['title'] . '</a>';
			}

			$links = array_merge( $links, $new_links );
		}

		return $links;
	}
}
