<?php
namespace BPVMWP\Controllers\Pages;

use BPVMWP\Helpers\Common;

/**
 * Class ReportDownloader
 *
 * Handles file download requests and updates download counts.
 *
 * @package BPVMWP
 */
class ReportDownloader {

	/**
	 * Register.
	 */
	public function register() {

		if ( is_admin() ) {
			$this->handle_download_request();
		}

	}

	/**
	 * Handle download request.
	 *
	 * @return void
	 */
	public function handle_download_request() {

		if ( isset( $_POST['report_nonce'] ) ) {

			if ( ! current_user_can( 'manage_options' ) ) {
				esc_html_e( 'Permission denied', 'bwl-pro-voting-manager' );
				wp_die();
			}

			if ( ! check_ajax_referer( BPVM_ADMIN_NONCE_ID, 'report_nonce', false ) ) {
				esc_html_e( 'Invalid nonce', 'bwl-pro-voting-manager' );
				wp_die();
			}

			global $wpdb;
			$table_vote_data    = TABLE_BPVM_DATA;
			$table_vote_summary = TABLE_BPVM_SUMMARY;

			$post_id               = $_POST['mv_post_title'] ?? -1; // Get post ID
			$post_type             = isset( $_POST['mv_bpvm_post_type'] ) ? sanitize_text_field( $_POST['mv_bpvm_post_type'] ) : '';
			$mv_post_filters       = isset( $_POST['mv_post_filters'] ) ? sanitize_text_field( $_POST['mv_post_filters'] ) : '';
			$mv_vote_info_type     = isset( $_POST['mv_vote_info_type'] ) ? sanitize_text_field( $_POST['mv_vote_info_type'] ) : '';
			$pvm_custom_date_range = isset( $_POST['pvm_custom_date_range'] ) ? 1 : 0;
			$pvm_filter_start_date = isset( $_POST['pvm_filter_start_date'] ) ? sanitize_text_field( $_POST['pvm_filter_start_date'] ) : '';
			$pvm_filter_end_date   = isset( $_POST['pvm_filter_end_date'] ) ? sanitize_text_field( $_POST['pvm_filter_end_date'] ) : '';

			// End of total votes count.

			$con_mv_post_filters = '';

			if ( $post_id > 0 ) {
				$con_mv_post_filters .= 'postid = %d AND ';
				$vars[]               = $post_id;
			} else {
				$mv_vote_info_type = 2;  // download all details of vote.
			}

			$vars[]               = $post_type;
			$con_mv_post_filters .= 'post_type = %s ';

			if ( $mv_post_filters != '' ) {
				$con_mv_post_filters .= ' AND vote_type = %d ';
				$vars[]               = $mv_post_filters;
			}

			$con_mv_date_range_filters = '';

			if ( $pvm_custom_date_range ) {
				$pvm_filter_start_date = empty( $pvm_filter_start_date ) ? '2013-04-01' : $pvm_filter_start_date;
				$pvm_filter_end_date   = empty( $pvm_filter_end_date ) ? date( 'Y-m-d' ) : $pvm_filter_end_date;

				$con_mv_date_range_filters .= ' AND DATE(vote_date) >= %s AND DATE(vote_date) <= %s ';

				$vars[] = $pvm_filter_start_date;
				$vars[] = $pvm_filter_end_date;
			}

			if ( $mv_vote_info_type == 2 ) {

				// Get each votes info in details. ( Details )

				$sql = $wpdb->prepare(
                    "SELECT ID, postid, vote_date, DATE(vote_date) as only_date, vote_type, votes,user_id,voted_ip FROM {$table_vote_data} 
                    WHERE 
                    " . $con_mv_post_filters . '
                    ' . $con_mv_date_range_filters . '
                    ORDER BY vote_date DESC', $vars
				);
			} else {

				// Only count the total votes. ( Summary )

				$sql = $wpdb->prepare(
                    "SELECT postid, vote_date, vote_type, total_votes as votes FROM {$table_vote_summary}   
                    WHERE 
                    " . $con_mv_post_filters . '
                    ' . $con_mv_date_range_filters . '
                    ORDER BY vote_date DESC', $vars
				);
			}

			// Generate data from query.

			$pvm_votes_data = $wpdb->get_results( $sql, ARRAY_A );

			$pvm_filtered_data = [];

			if ( count( $pvm_votes_data ) > 0 ) :

				array_push(
                    $pvm_filtered_data, [
						'post_id',
						'post_type',
						'vote_date',
						'vote_type',
						'votes_count',
						'user_id',
						'voted_ip',
                    ]
				);

				foreach ( $pvm_votes_data as $vote_data ) :

					$post_id        = $vote_data['postid'];
					$user_id        = $vote_data['user_id'] ?? '-';
					$voted_ip       = $vote_data['voted_ip'] ?? '-';
					$vote_type      = ( intval( $vote_data['vote_type'] ) === 2 ) ? 2 : 1; // 2 = Dislike, 1 = Like
					$vote_type_text = ( $vote_type === 2 ) ? 'Dislike' : 'Like';

					if ( ( $mv_vote_info_type == 2 ) && ( $user_id != '-' ) ) {
						$user_id = ( $user_id === 0 ) ? 'Visitor' : get_userdata( $user_id )->display_name;
					}

					array_push(
                        $pvm_filtered_data, [
							$post_id,
							$post_type,
							Common::human_date_format( $vote_data['vote_date'] ),
							$vote_type_text,
							$vote_data['votes'],
							$user_id,
							$voted_ip,
                        ]
					);

				endforeach;

			endif;

			wp_reset_postdata();

			$output_file_name = 'pvm_data.' . date( 'Y-m-d-H-i-s' ) . '.csv';

			header( 'Content-Description: File Transfer' );
			header( 'Content-Disposition: attachment; filename=' . $output_file_name );
			header( 'Content-Type: text/csv; charset=' . get_option( 'blog_charset' ), true );

			$input_array = $pvm_filtered_data;

			$delimiter = ',';
			$f         = fopen( 'php://memory', 'w' );
			foreach ( $input_array as $line ) {
				fputcsv( $f, $line, $delimiter );
			}
			fseek( $f, 0 );
			header( 'Content-Type: application/csv' );
			header( 'Content-Disposition: attachement; filename="' . $output_file_name . '";' );
			fpassthru( $f );
			exit;
		}
	}
}
