<?php
namespace BPVMWP\Controllers\Pages;

use Xenioushk\BwlPluginApi\Api\Pages\PluginPagesApi;

use BPVMWP\Callbacks\Pages\PluginAddonsCb;
use BPVMWP\Callbacks\Pages\VotingReportCb;
use BPVMWP\Callbacks\Pages\VisualReportCb;
use BPVMWP\Callbacks\Pages\OurProductsCb;

/**
 * Class for Initialize plugin pages
 *
 * @since: 1.0.0
 * @package BPVMWP
 */
class PluginPages {

	/**
	 * Plugin pages settings.
	 *
	 * @var array $pages_settings
	 */
	public $pages_settings = [];

	/**
	 * Register pages.
	 */
	public function register() {

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$plugin_pages     = new PluginPagesApi( BPVM_ADMIN_PARENT_MENU_SLUG,true );
		$plugin_addons_cb = new PluginAddonsCb();
		$voting_report_cb = new VotingReportCb();

		$our_products = get_option( BPVM_CRON_BWL_PRODUCTS_OPTION_ID ) ?? [];
		$sale_badge   = ! empty( $our_products ) ? '<span class="bpvm-license-activation-tag inactive">Sale</span>' : '';

		$pages_settings = [
			[
				'page_title' => esc_html__( 'Voting Report Manager', 'bwl-pro-voting-manager' ),
				'menu_title' => esc_html__( 'Voting Report', 'bwl-pro-voting-manager' ),
				'menu_slug'  => 'bpvm-voting-report',
				'cb'         => [ $voting_report_cb, 'load_template' ],
			],
			[
				'page_title' => esc_html__( 'Voting Visual Report Manager', 'bwl-pro-voting-manager' ),
				'menu_title' => esc_html__( 'Visual Report', 'bwl-pro-voting-manager' ) . '<span class="bpvm-license-activation-tag activated">🔥 New</span>',
				'menu_slug'  => 'bpvm-visual-report',
				'cb'         => [ ( new VisualReportCb() ), 'load_template' ],
			],
			[
				'page_title' => esc_html__( 'BWL Pro Voting Manager Addons', 'bwl-pro-voting-manager' ),
				'menu_title' => esc_html__( 'Addons', 'bwl-pro-voting-manager' ),
				'menu_slug'  => 'bpvm-addons',
				'cb'         => [ $plugin_addons_cb, 'load_template' ],
			],
			[
				'page_title' => esc_attr__( 'More products from BlueWindLab !', 'bwl-pro-voting-manager' ),
				'menu_title' => esc_attr__( 'More Products', 'bwl-pro-voting-manager' ) . $sale_badge,
				'menu_slug'  => 'bwl-products',
				'cb'         => [ ( new OurProductsCb() ), 'load_template' ],
				'position'   => 123,
			],

		];

		$plugin_pages->add_plugin_pages( $pages_settings )->register();
	}
}
