<?php
namespace BPVMWP\Controllers\Notices;

use Xenioushk\BwlPluginApi\Api\AjaxHandlers\AjaxHandlersApi;
use BPVMWP\Callbacks\Notices\NoticeAjaxHandlerCb;

/**
 * PluginNoticesAjaxHandler class.
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class PluginNoticesAjaxHandler {

	/**
	 * Register PluginNoticesAjaxHandler.
	 */
	public function register() {

		// Initialize API.
		$ajax_handlers_api = new AjaxHandlersApi();

		// Initialize callbacks.
		$notice_ajax_handler_cb = new NoticeAjaxHandlerCb();

		// Add all the ajax handlers here.
		$settings = [
			[
				'tag'      => 'bpvm_set_notice_status',
				'callback' => [ $notice_ajax_handler_cb, 'save_notice_settings' ],
			],
		];

		$ajax_handlers_api->add_ajax_handlers( $settings )->register();
	}
}
