<?php
namespace BPVMWP\Controllers\Database;

use Xenioushk\BwlPluginApi\Api\Database\TableManagerApi;
/**
 * Class for plugin tables.
 *
 * @since: 1.1.6
 * @package BPVMWP
 */
class Tables {

    /**
     *  Instance of the WPDB.
     *
     * @var object $wpdb
     */
    private $wpdb;

    /**
     *  Instance of the Table Manager API.
     *
     * @var object $table_manager_api
     */
    private $table_manager_api;

    /**
     * Constructor for the class.
     *
     * @param object $wpdb  Instance of the WPDB.
     */
    public function __construct( $wpdb ) {
        $this->wpdb = $wpdb;
    }

    /**
	 * Register shortcode.
	 */
    public function register() {

        // Initialize API.
        $this->table_manager_api = new TableManagerApi( $this->wpdb );

        $this->table_manager_api->register_tables_info( $this->get_the_tables_info() )->register();
    }

    /**
     * Get the tables info.
     *
     * @return array $tables_info
     */
    public function get_the_tables_info() {

        $tables_info = [
            [
                'table_name' => $this->wpdb->prefix . 'bpvm_data',
                'schema'     => "ID int(11) NOT NULL AUTO_INCREMENT,
                                        postid bigint(20) NOT NULL,
                                        post_type varchar(200) NOT NULL,
                                        vote_type int(20) DEFAULT 1,
                                        votes bigint(20) DEFAULT 1,
                                        vote_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                                        voted_ip VARCHAR(24) NOT NULL, 
                                        user_id INT NOT NULL DEFAULT '0',
                                        PRIMARY KEY  (ID)",
            ],
			[
				'table_name' => $this->wpdb->prefix . 'bpvm_summary',
				'schema'     => "ID bigint(20) NOT NULL AUTO_INCREMENT,
                                        postid bigint(20) NOT NULL,
                                        post_type varchar(200) NOT NULL,
                                        vote_type int(20) DEFAULT 1,
                                        vote_date date NOT NULL DEFAULT '0000-00-00',
                                        total_votes bigint(20) NOT NULL DEFAULT 1,
                                        last_voted datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
                                        PRIMARY KEY  (ID)",
			],
        ];
        return $tables_info;
    }
}
