<?php

namespace BPVMWP\Controllers\DashboardWidgets;

use Xenioushk\BwlPluginApi\Api\DashboardWidgets\DashboardWidgetsApi;
use BPVMWP\Callbacks\DashboardWidgets\DashboardWidgetsCb;
/**
 * Class for PluginDashboardWidgets
 *
 * @package BPVM
 */
class PluginDashboardWidgets {

	/**
	 * Register the dashboard widgets.
	 *
	 * @return void
	 */
	public function register() {

		// Initialize API.
		$dashboard_widgets_api = new DashboardWidgetsApi();

		// Initialize callbacks.
		$dashboardWidgetsCb = new DashboardWidgetsCb();

		// Add all the dashwidgets here.
		$dashboard_widgets = [
			[
				'slug'  => 'bpvm-plugin-summary',
				'title' => BPVM_PLUGIN_TITLE . ' - ' . BPVM_PLUGIN_VERSION,
				'cb'    => [ $dashboardWidgetsCb, 'get_plugin_summary' ],
			],
		];

		$dashboard_widgets_api->add_dash_widgets( $dashboard_widgets )->register();
	}
}
