<?php
namespace BPVMWP\Controllers\Admin;

use BPVMWP\Helpers\BpvmHelper;

/**
 * Custom Columns
 *
 * @package BPVMWP
 */
class CustomColumns {

    /**
     * Register the column filters.
     */
	public function register() {
		if ( is_admin() ) {

			$post_types = bpvm_admin_filter_cpt( bpvm_get_all_post_types() );

			foreach ( $post_types as $post_type ) {

				$post_types = 'posts';

				if ( $post_type == 'page' ) {

					$post_types = 'pages';
				} else {

					$post_types = $post_type . '_posts';
				}

				add_filter( 'manage_' . $post_types . '_columns', [ $this, 'column_header' ] );
				add_action( 'manage_' . $post_types . '_custom_column', [ $this, 'column_content' ] );
			}
		}
	}

	/**
	 * Display Custom Columns Header For Voting Manager Plugin.
	 *
	 * @param array $columns Column.
	 */
	public function column_header( $columns ) {

		return array_merge(
            $columns,
            [
				'pvm_like_votes_count'    => esc_html__( 'Like', 'bwl-pro-voting-manager' ),
				'pvm_dislike_votes_count' => esc_html__( 'Dislike', 'bwl-pro-voting-manager' ),
				'pvm_feedback'            => esc_html__( 'Feedback', 'bwl-pro-voting-manager' ),
				'bwl_pvm_display_status'  => esc_html__( 'Vote', 'bwl-pro-voting-manager' ) . '<br />' . esc_html__( 'Status', 'bwl-pro-voting-manager' ),
            ]
		);
	}

	/**
	 * Display Custom Columns Data For Voting Manager Plugin.
	 *
	 * @param string $column Column name.
	 */
	public function column_content( $column ) {

		// Add A Custom Image Size For Admin Panel.

		global $post;

		switch ( $column ) {

			case 'pvm_like_votes_count':
				$count = BpvmHelper::bpvm_get_vote_counts_meta( $post->ID );
				echo "<div id='pvm_like_votes_count-{$post->ID}'>{$count}</div>"; //phpcs:ignore

				break;

			case 'pvm_dislike_votes_count':
				$count = BpvmHelper::bpvm_get_vote_counts_meta( $post->ID, 2 );
				echo "<div id='pvm_dislike_votes_count-{$post->ID}'>{$count}</div>"; //phpcs:ignore
				break;

			case 'bwl_pvm_display_status':
				$display_status = ( get_post_meta( $post->ID, 'bwl_pvm_display_status', true ) == '' ) ? 1 : get_post_meta( $post->ID, 'bwl_pvm_display_status', true );

				switch ( $display_status ) {
					case '4':
						$status_text = esc_html__( 'Date Range', 'bwl-pro-voting-manager' );
						break;

					case '3':
						$status_text = esc_html__( 'Paused', 'bwl-pro-voting-manager' );
						break;

					case '2':
						$status_text = esc_html__( 'Closed', 'bwl-pro-voting-manager' );
						break;

					case '1':
						$status_text = esc_html__( 'Show', 'bwl-pro-voting-manager' );
						break;

					default:
						$status_text = esc_html__( 'Hidden', 'bwl-pro-voting-manager' );
						break;
				}

				echo '<div id="bwl_pvm_display_status-' . $post->ID . '" data-status_code="' . $display_status . '">' . $status_text . '</div>';

				break;

			case 'pvm_feedback':
				// so idea is we are going to add post id after vairable name
				$feedback_unique_id = 'pvm_feedback_list_' . $post->ID;

				$feedback = get_post_meta( $post->ID, $feedback_unique_id );

				$counter = ( isset( $feedback[0] ) && ! empty( $feedback[0] ) ) ? count( $feedback[0] ) : 0;

				echo '<div id="pvm_dislike_votes_count-' . $post->ID . '" class="pvm_alignment">' . $counter . '</div>';

				break;
		}
	}
}
