<?php
namespace BPVMWP\Controllers\Actions\Admin;

use Xenioushk\BwlPluginApi\Api\Actions\ActionsApi;
use BPVMWP\Callbacks\Actions\Admin\QuickBulkEditBoxCb;
use BPVMWP\Callbacks\Actions\Admin\QuickEditSaveCb;

/**
 * Class for Quick and Bulk Edit items.
 *
 * @since: 1.1.5
 * @package BPVMWP
 */
class QuickBulkEdit {

    /**
	 * Register actions.
	 */
    public function register() {

        if ( ! is_admin() ) {
            return;
        }

        // Initialize API.
        $actions_api = new ActionsApi();

        // Initialize callbacks.
        $quick_bulk_edit_box_cb = new QuickBulkEditBoxCb();
        $quick_edit_save_cb     = new QuickEditSaveCb();

        // Actions.
        // @Note: For Bulk edit data, navigate to the Base/AdminAjaxHandlers.php.
        $actions = [
            [
                'tag'        => 'quick_edit_custom_box',
                'callback'   => [ $quick_bulk_edit_box_cb, 'get_quick_bulk_edit_box' ],
                'args_count' => 2,
            ],
            [
                'tag'        => 'bulk_edit_custom_box',
                'callback'   => [ $quick_bulk_edit_box_cb, 'get_quick_bulk_edit_box' ],
                'args_count' => 2,
            ],
            [
                'tag'        => 'save_post',
                'callback'   => [ $quick_edit_save_cb, 'save_data' ],
                'args_count' => 2,
            ],
        ];

        $actions_api->add_actions( $actions )->register();
    }
}
