<?php
namespace BPVMWP\Callbacks\Shortcodes;

/**
 * Class Vote Statistics Callback
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class VoteStatsCb {

	/**
	 * Generates the shortcode output.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string The login form HTML.
	 */
	public function get_the_output( $atts ) {

		$atts = shortcode_atts([
            'post_type_filter' => 0,
			'post_type'        => 'post',
			'month_range'      => 1,
		], $atts);
		extract( $atts ); // phpcs:ignore

		global $wpdb;
		$post_table = $wpdb->prefix . 'posts'; // posts table from database.
		$order      = 'DESC';

		$post_type_filter_query = '';

		if ( $post_type_filter == 1 ) {
			$post_type_filter_query .= ' ' . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}' AND ";
		}

		$query = "SELECT {$post_table}.ID FROM `" . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
        . '     WHERE 1 AND '
        . $wpdb->prefix . "bpvm_summary.postid = {$post_table}.ID AND "
        . " {$post_table}.post_status = 'publish' AND "
        . $post_type_filter_query .
        " {$post_table}.post_date BETWEEN now() - interval {$month_range} month AND now() GROUP BY {$post_table}.ID";

		$query_results         = $wpdb->get_results( $query );
		$total_posts_published = '<li>' . esc_html__( 'Total Posts Published:', 'bwl-pro-voting-manager' ) . $wpdb->num_rows . '</li>';

		wp_reset_query();

		$query = 'SELECT SUM(`total_votes`) AS liked_votes FROM `' . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
        . '  WHERE 1 AND '
        . $wpdb->prefix . "bpvm_summary.postid = {$post_table}.ID AND "
        . " {$post_table}.post_status = 'publish' AND "
        . $post_type_filter_query .
        ' ' . $wpdb->prefix . 'bpvm_summary.vote_type=1 AND ' .
        "{$post_table}.post_date BETWEEN now() - interval {$month_range} month AND now() ORDER BY liked_votes {$order}";

		$query_results    = $wpdb->get_results( $query );
		$total_like_votes = '<li>' . esc_html__( 'Total Like Votes:', 'bwl-pro-voting-manager' ) . $query_results[0]->liked_votes . '</li>';

		wp_reset_query();

		$query = 'SELECT SUM(`total_votes`) AS disliked_votes FROM `' . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
        . '  WHERE 1 AND '
        . $wpdb->prefix . "bpvm_summary.postid = {$post_table}.ID AND "
        . " {$post_table}.post_status = 'publish' AND "
        . $post_type_filter_query .
        ' ' . $wpdb->prefix . 'bpvm_summary.vote_type=2 AND ' .
        "{$post_table}.post_date BETWEEN now() - interval {$month_range} month AND now() ORDER BY disliked_votes {$order}";

		$query_results       = $wpdb->get_results( $query );
		$total_dislike_votes = '<li>' . esc_html__( 'Total Dislike Votes:', 'bwl-pro-voting-manager' ) . $query_results[0]->disliked_votes . '</li>';

		wp_reset_query();

		$final_output = '';

		$final_output .= '<div class="bpvm-vote-stats">';
		$final_output .= '<ul>';
		$final_output .= $total_posts_published;
		$final_output .= $total_like_votes;
		$final_output .= $total_dislike_votes;
		$final_output .= '</ul>';
		$final_output .= '</div>';

		return $final_output;
	}
}
