<?php
namespace BPVMWP\Callbacks\Shortcodes;

use BPVMWP\Helpers\BpvmHelper;

/**
 * Class Vote Results Callback
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class VoteResultsCb {

	/**
	 * Generates the shortcode output.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string The login form HTML.
	 */
	public function get_the_output( $atts ) {

		$atts = shortcode_atts([
			'show_like'    => 1,
			'show_dislike' => 1,
			'show_icon'    => 1,
		], $atts);
		extract( $atts ); // phpcs:ignore

		global $post;

		$post_id = get_the_ID();

		$pvm_data = get_option( 'bwl_pvm_options' );

		/*--- Add Custom Icon For Like Button ---*/

		$pvm_like_results = '';

		if ( $show_like == 1 ) {

			$like_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );

			if ( $like_vote_counter == '' ) {
				$like_vote_counter = 0;
			}

			if ( isset( $pvm_data['pvm_like_thumb_icon'] ) && $pvm_data['pvm_like_thumb_icon'] != '' ) {

				$pvm_like_thumb_icon = $pvm_data['pvm_like_thumb_icon'];

				$pvm_like_results .= '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i> ';
			} else {

				$pvm_like_thumb_icon = 'fa-thumbs-o-up';

				$pvm_like_results .= '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i> ';
			}

			$pvm_like_results .= $like_vote_counter . ' ';
		}

		/*--- Add Custom Icon For Dislike Button ---*/

		$pvm_dislike_results = '';

		if ( $show_dislike == 1 ) {

			$dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

			if ( $dislike_vote_counter == '' ) {
				$dislike_vote_counter = 0;
			}

			if ( isset( $pvm_data['pvm_dislike_thumb_icon'] ) && $pvm_data['pvm_dislike_thumb_icon'] != '' ) {

				$pvm_dislike_thumb_icon = $pvm_data['pvm_dislike_thumb_icon'];

				$pvm_dislike_results .= '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i> ';
			} else {

				$pvm_dislike_thumb_icon = 'fa-thumbs-o-down';

				$pvm_dislike_results .= '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i> ';
			}

			$pvm_dislike_results .= $dislike_vote_counter;
		}

		$pvm_result_string = $pvm_like_results . $pvm_dislike_results;

		return $pvm_result_string;
	}
}
