<?php
namespace BPVMWP\Callbacks\Shortcodes;

use BPVMWP\Helpers\BpvmHelper;
use BPVMWP\Helpers\PluginConstants;

/**
 * Class VoteLayoutCb handles the voting layout callbacks.
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class VoteLayoutCb {

	/**
	 * @var int Post ID.
	 */
	private $post_id;

	/**
	 * @var string Post type.
	 */
	private $post_type;

	/**
	 * @var int Unique identifier for the instance.
	 */
	private $unique_id;

	/**
	 * Generates the shortcode output.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string The login form HTML.
	 */
	public function get_the_output( $atts ) {

		global $post;

		$atts = shortcode_atts([
			'id'            => get_the_ID(),
			'status'        => 1,
			'post_type'     => get_post_type( get_the_ID() ),
			'woo'           => 0, // Provide support for WooCommerce page default woo is zero
			'animation'     => 0,
			'like_theme'    => '',
			'dislike_theme' => '',
			'dpc'           => 0, // Display post content (For video post types)
			'voting_filter' => 0, // Display some custom elements here within a date range,
			'class'         => '',
        ], $atts);
		extract( $atts ); // phpcs:ignore

		if ( empty( $id ) ) {
			return '';
		}

		$this->post_id   = $id;
		$this->post_type = $post_type;
		$this->unique_id = wp_rand();
		return $this->generate_html( $status, $animation, $like_theme, $dislike_theme, $dpc, $voting_filter, $woo, $class );

	}

	/**
	 * Generate the HTML for the voting layout.
	 *
	 * @param int    $bwl_pvm_display_status Voting display status.  0. Hide 1. Show, 2. Voting Close.
	 * @param int    $animation Animation status.
	 * @param string $like_theme Custom like theme.
	 * @param string $dislike_theme Custom dislike theme.
	 * @param int    $dpc Display post content status.
	 * @param int    $voting_filter Voting filter status.
	 * @param int    $woo WooCommerce status.
	 * @param string $class Additional CSS class.
	 * @return string Generated HTML content.
	 */
	public function generate_html( $bwl_pvm_display_status, $animation, $like_theme, $dislike_theme, $dpc, $voting_filter, $woo, $class ) {

		$post_id   = $this->post_id;
		$post_type = $this->post_type;
		$pvm_data  = PluginConstants::$plugin_options;

		$content        = '';
		$bpvm_unique_id = $this->unique_id;

		$class                   = ( ! empty( $class ) ) ? ' ' . $class . ' ' : '';
		$bwl_pvm_container_class = 'bwl_pvm_container' . $class;

		if ( ! empty( $bwl_pvm_display_status ) && $bwl_pvm_display_status == 0 ) {

			return $content;
		}

		if ( ! empty( $bwl_pvm_display_status ) && $bwl_pvm_display_status == 2 ) {

			/*--- BUILD INTERFACE ---*/

			$pvm_interface = '<div class="' . $bwl_pvm_container_class . '">
                                        <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_html__( 'Voting Closed !', 'bwl-pro-voting-manager' ) . '</p>
                                     </div><!-- end .bwl_pvm_container -->';

			$content .= $pvm_interface;

			return $content;
		} elseif ( ! empty( $bwl_pvm_display_status ) && $bwl_pvm_display_status == 4 ) {

			/*--- BUILD INTERFACE---*/
			$bpvm_vote_start_date = get_post_meta( $post_id, 'bpvm_vote_start_date', true );
			$pvm_interface        = '<div class="' . $bwl_pvm_container_class . '">
                                  <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_html__( 'Voting start date: ', 'bwl-pro-voting-manager' ) . ' ' . bpvm_change_date_format( $bpvm_vote_start_date ) . '</p>
                                 </div><!-- end .bwl_pvm_container -->';

			$content .= $pvm_interface;
			return $content;
		} elseif ( ! empty( $bwl_pvm_display_status ) && $bwl_pvm_display_status == 5 ) {

			/*--- BUILD INTERFACE---*/

			$pvm_interface = '<div class="' . $bwl_pvm_container_class . '">
                                  <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_html__( 'Voting date expired !', 'bwl-pro-voting-manager' ) . '</p>
                                 </div><!-- end .bwl_pvm_container -->';

			$content .= $pvm_interface;

			return $content;
		}

		// Display Voting Closed Message.

		$like_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );

		$dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

		$pvm_feedback_message_unique_id = 'pvm_feedback_list_' . $post_id; // so idea is we are going to add post id after vairable name

		$prev_pvm_feedback_message = get_post_meta( $post_id, $pvm_feedback_message_unique_id );

		$total_vote_counter = $like_vote_counter + $dislike_vote_counter;

		// Fixed in version 1.0.6

		$like_percentage    = 0;
		$dislike_percentage = 0;
		$result_percentage  = 0;

		if ( $total_vote_counter !== 0 ) {

			$like_percentage = ceil( BpvmHelper::calculate_percentage( $total_vote_counter, $like_vote_counter ) );

			$dislike_percentage = 100 - $like_percentage;
		}

		if ( isset( $pvm_data['pvm_display_result_percentage'] ) && $pvm_data['pvm_display_result_percentage'] == 1 ) {
			$like_vote_counter    = $like_percentage . '%';
			$dislike_vote_counter = $dislike_percentage . '%';
			$result_percentage    = 1;
		}

		// Add Custom Icon For Like Button
		$pvm_like_thumb_icon = $pvm_data['pvm_like_thumb_icon'] ?? 'fa-thumbs-o-up';
		$pvm_like_thumb_html = '<i class="fa ' . $pvm_like_thumb_icon . ' icon_like_color"></i>';

		// Add Custom Icon For Dislike Button
		$pvm_dislike_thumb_icon = $pvm_data['pvm_dislike_thumb_icon'] ?? 'fa-thumbs-o-down';
		$pvm_dislike_thumb_html = '<i class="fa ' . $pvm_dislike_thumb_icon . ' icon_dislike_color"></i>';

		/*--- Custom Image For Like Button---*/

		if ( isset( $pvm_data['pvm_like_conditinal_fields']['enabled'] ) && $pvm_data['pvm_like_conditinal_fields']['enabled'] == 'on' ) {

			$pvm_custom_like_icon = $pvm_data['pvm_like_conditinal_fields']['pvm_custom_like_icon'];

			if ( isset( $pvm_custom_like_icon['src'] ) && $pvm_custom_like_icon['src'] != '' ) {

				$pvm_like_thumb_html = '<img src="' . $pvm_custom_like_icon['src'] . '" class="pvm-custom-icon"/>';
			}
		}

		/*--- Custom Image For Dislike Button---*/

		if ( isset( $pvm_data['pvm_dislike_conditinal_fields']['enabled'] ) && $pvm_data['pvm_dislike_conditinal_fields']['enabled'] == 'on' ) {

			$pvm_custom_dislike_icon = $pvm_data['pvm_dislike_conditinal_fields']['pvm_custom_dislike_icon'];

			if ( isset( $pvm_custom_dislike_icon['src'] ) && $pvm_custom_dislike_icon['src'] != '' ) {

				$pvm_dislike_thumb_html = '<img src="' . $pvm_custom_dislike_icon['src'] . '" class="pvm-custom-icon"/>';
			}
		}

		// Down/Dislike Vote Status
		$pvm_disable_down_vote_status = intval( $pvm_data['pvm_disable_down_vote_status'] ?? 0 );

		// ADD VOTE STATUS

		$vote_given_status = 0;

		// Tipsy like title.
		$pvm_tipsy_like_title = $pvm_data['pvm_tipsy_like_title'] ?? esc_html__( 'Like The Post', 'bwl-pro-voting-manager' );

		// Tipsy dislike title.
		$pvm_tipsy_dislike_title = $pvm_data['pvm_tipsy_dislike_title'] ?? esc_html__( 'Dislike The Post', 'bwl-pro-voting-manager' );

		if ( $vote_given_status == 1 ) {

			$pvm_btn_container_html = '<div class="msg_container" id="msg_container_' . $post_id . '"> ' . esc_html__( 'Loading .....', 'bwl-pro-voting-manager' ) . '</div>';
		} elseif ( $pvm_disable_down_vote_status ) {

            $pvm_btn_container_html = '<div class="btn_like" title="' . $pvm_tipsy_like_title . '" vote_status="1" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '">' . $pvm_like_thumb_html . '</div>';
		} else {

			$pvm_btn_container_html = '<div class="btn_like" title="' . $pvm_tipsy_like_title . '" vote_status="1" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '">' . $pvm_like_thumb_html . '</div>
                                               <div class="btn_dislike" title="' . $pvm_tipsy_dislike_title . '" vote_status="0" post_id="' . $post_id . '" bpvm_unique_id="' . $bpvm_unique_id . '">' . $pvm_dislike_thumb_html . '</div>';
		}

		/*--- BUILD INTERFACE---*/

		// Voting bar status.

		$pvm_disable_voting_bar_status = $pvm_data['pvm_disable_voting_bar_status'] ?? 0;

		if ( $pvm_disable_voting_bar_status ) {

			$pvm_bar_html = '<div class="stat-bar-blank"></div><!-- end .stat-bar-blank -->';

		} else {

			$voting_bar_type = get_post_meta( $post_id, 'bwl_pvm_voting_bar_type', true ) ?? 0;

			$bwl_pvm_voting_bar_type = $voting_bar_type;

			if ( $bwl_pvm_voting_bar_type == 1 || $animation == 1 ) {

				// Custom Like Theme
				if ( ! empty( $like_theme ) ) {
					$bwl_pvm_like_bar_theme = $like_theme;
				} else {
					$like_bar_theme         = get_post_meta( $post_id, 'bwl_pvm_like_bar_theme', true );
					$bwl_pvm_like_bar_theme = ! empty( $like_bar_theme ) ? $like_bar_theme : 'animated_green_theme';
				}

				// Custom Dislike Theme
				if ( ! empty( $dislike_theme ) ) {
					$bwl_pvm_dislike_bar_theme = $dislike_theme;
				} else {
					$dislike_bar_theme         = get_post_meta( $post_id, 'bwl_pvm_dislike_bar_theme', true );
					$bwl_pvm_dislike_bar_theme = ! empty( $dislike_bar_theme ) ? $dislike_bar_theme : 'animated_red_theme';
				}

				$bar_fill    = '<div class="barFill"></div>';
				$like_bar    = sprintf( '<div class="bpvm_animated_bar like_percentage %s" style="width:%s;">%s</div>', $bwl_pvm_like_bar_theme, $like_percentage . '%',$bar_fill );
				$dislike_bar = sprintf( '<div class="bpvm_animated_bar dislike_percentage %s" style="width:%s;">%s</div>', $bwl_pvm_dislike_bar_theme, $dislike_percentage . '%',$bar_fill );

			} else {

				$like_bar    = sprintf( '<div class="bg-green like_percentage" style="width:%s;"></div>', $like_percentage . '%' );
				$dislike_bar = sprintf( '<div class="bg-red dislike_percentage" style="width:%s;"></div>', $dislike_percentage . '%' );
			}

			// Generate the voting bar html.
			$pvm_bar_html = '<div class="stat-bar">
																	<div class="bpvm_animated_bar">
																			' . $like_bar . '
																			' . $dislike_bar . '
																	</div>
															</div><!-- end .stat-bar -->';
		}

		$pvm_like_count_container_string    = "<div class='like-count-container'>{$pvm_like_thumb_html} <span>{$like_vote_counter}</span></div>";
		$pvm_dislike_count_container_string = "<div class='dislike-count-container'>{$pvm_dislike_thumb_html} <span>{$dislike_vote_counter}</span></div>";
		$pvm_store_dislike_string           = $pvm_dislike_count_container_string; // create a backup for dislike count container string

		if ( $pvm_disable_down_vote_status && ! empty( $bwl_pvm_display_status ) && $bwl_pvm_display_status != 3 ) {
			$pvm_dislike_count_container_string = '';
		}

		/*--- Voting Paused Checking---*/

		if ( ! empty( $bwl_pvm_display_status ) && $bwl_pvm_display_status == 3 ) {
			$pvm_btn_container_html = '<p class="voting-paused-message"><i class="fa fa-info-circle"></i> ' . esc_html__( 'Voting Paused !', 'bwl-pro-voting-manager' ) . '</p>';
		}

		/*--- User Role Filtering---*/

		if ( isset( $pvm_data['pvm_role_status']['enabled'] ) && $pvm_data['pvm_role_status']['enabled'] == 'on' ) {

			// Fixed in version 1.1.2
			// Always admin user can submit vote.
			$pvm_enabled_roles = isset( $pvm_data['pvm_role_status']['pvm_enabled_roles'] ) ? $pvm_data['pvm_role_status']['pvm_enabled_roles'] : [ 'administrator' ];

			$pvm_enabled_roles = array_map( 'strtolower', $pvm_enabled_roles );

			$pvm_current_use_info = wp_get_current_user();

			if ( ! array_intersect( $pvm_enabled_roles, $pvm_current_use_info->roles ) ) {
				// stuff here for allowed roles
				$pvm_btn_container_html             = '<p class="voting-paused-message"><i class="fa fa-warning"></i> ' . esc_html__( 'Sorry, You are not allowed to submit vote !', 'bwl-pro-voting-manager' ) . '</p>';
				$pvm_dislike_count_container_string = $pvm_store_dislike_string;
			}
		}

		$pvm_custom_theme = '';

		if ( isset( $woo ) && $woo == 1 ) {
			$pvm_custom_theme .= ' woo_pvm_theme';

			$pvm_alt_dislike_string = $pvm_dislike_count_container_string;

			if ( isset( $_GET['orderby'] ) && $_GET['orderby'] == 'pvm_dislike_votes_count' ) {

				$pvm_dislike_count_container_string = $pvm_like_count_container_string;
				$pvm_like_count_container_string    = $pvm_alt_dislike_string;
			}
		}

		$pvm_interface = "<div class='{$bwl_pvm_container_class} {$pvm_custom_theme}'>
                                 <div class='pvm_btn_container' id='pvm_btn_container_{$bpvm_unique_id}'> 
                                    {$pvm_btn_container_html}
                                 </div>
                                <div class='stat-cnt' id='stat-cnt-{$bpvm_unique_id}' data-result_percentage='{$result_percentage}'>
                                    <div class='total-vote-counter'>" . esc_html__( 'Total', 'bwl-pro-voting-manager' ) . " <span>{$total_vote_counter}</span> " . esc_html__( 'Votes', 'bwl-pro-voting-manager' ) . "</div>
                                        {$pvm_bar_html}
                                    <div class='count-container'>
                                        {$pvm_like_count_container_string}
                                        {$pvm_dislike_count_container_string}
                                    </div>
                                </div>
                            </div>";

		if ( $dpc == 1 ) {

			$post_info = get_post( $post_id );

			$content .= do_shortcode( '[video src="' . $post_info->post_content . '"][/video]' );
		}

		$content .= $pvm_interface;

		// Fixed in version 1.1.4

		$content .= $this->get_feedback_form();

		return $content;
	}

	/**
	 * Generates captcha field
	 *
	 * @return string The captcha field HTML.
	 */
	private function get_captcha_field() {
		$captcha_status = 1;
		$title          = esc_html__( 'Captcha:', 'bwl-pro-voting-manager' );
		$bot_msg        = esc_html__( 'Verify Human or Spambot ?', 'bwl-pro-voting-manager' );
		$num_1          = wp_rand( 1, 4 );
		$num_2          = wp_rand( 5, 9 );
		$captcha        = "<div>
                                                <label for='captcha'>{$title}</label>
                                                    <input id='num1' class='sum' type='text' name='num1' value='{$num_1}' readonly='readonly'> +
                                                    <input id='num2' class='sum' type='text' name='num2' value='{$num_2}' readonly='readonly'> =
                                                    <input id='captcha' class='captcha' type='text' name='captcha' maxlength='2'>
                                                    <input id='captcha_status' type='hidden' name='captcha_status' value='{$captcha_status}'>
                                                <span id='spambot'>{$bot_msg}</span>
                                            </div>";
																						return $captcha;
	}


	/**
	 * Generates feedback from
	 *
	 * @return string The feedback form HTML.
	 */
	private function get_feedback_form() {

		$pvm_data = PluginConstants::$plugin_options;

		$pvm_form_body = '';

		$pvm_disable_feedback_status = intval( $pvm_data['pvm_disable_feedback_status'] ?? 0 );

		if ( $pvm_disable_feedback_status ) {
			return $pvm_form_body;
		}

		// Feedback Form Unique ID
		$pvm_form_id = 'pvm_feedback_form_' . $this->unique_id;

		/*--- Feedback Title---*/

			$pvm_feedback_form_title = ( isset( $pvm_data['pvm_feedback_form_title'] ) && ! empty( $pvm_data['pvm_feedback_form_title'] ) ) ?
																								// translators: %s: Feedback Form Title
																								sprintf( '%s', $pvm_data['pvm_feedback_form_title'] ) :
																								esc_html__( 'Tell us how can we improve this post?', 'bwl-pro-voting-manager' );

			$pvm_form_body = '<div class="bwl-pro-voting-feedback-form-container" id="' . $pvm_form_id . '">
                    
                                        <h2>' . $pvm_feedback_form_title . ' </h2>

                                        <div class="bwl_pro_form_error_message_box"></div>
                                            
                                        <form id="bwl_pvm_feedback_form" class="bwl_pvm_feedback_form" name="bwl_pvm_feedback_form" method="post" action="#"> 
                                        
                                                <div>
                                                    <textarea id="feedback_message" class="feedback_message_box" placeholder="' . esc_html__( 'Write feedback message ..... ', 'bwl-pro-voting-manager' ) . '"/></textarea>
                                                </div>
                                                ' . $this->get_captcha_field() . '

                                                <div class="pvm_feedback_submit_container">
                                                    <input type="submit" value="' . esc_html__( 'Submit', 'bwl-pro-voting-manager' ) . '" tabindex="6" id="submit" name="submit" bwl_pvm_feedback_form_id= "' . $pvm_form_id . '" post_id="' . $this->post_id . '" bpvm_unique_id="' . $this->unique_id . '"/>
                                                </div>

                                                <input type="hidden" name="post_type" id="post_type" value="bwl_pro_voting_manager">

                                                <input type="hidden" name="action" value="bwl_pro_voting_manager">
																								
																								</form>

                                        </div>';

		return $pvm_form_body;
	}
}
