<?php
namespace BPVMWP\Callbacks\Shortcodes;

use WP_Query;

/**
 * Class LoginForm Callbacks
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class TaxonomyFilterCb {

	/**
	 * Generates the shortcode output.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string The login form HTML.
	 * @example Create a list of top liked and disliked posts from a specific category. You can include multiple categories from a post type.
	 * @Shortcode: [pvm_taxonomy_filter taxonomy_cats="your-cat-slug"]
	 */
	public function get_the_output( $atts ) {

		$atts = shortcode_atts(
            [
				'title_tag'      => 'h4',
				'show_number'    => 1,
				'post_type'      => 'post',
				'meta_key'       => 'like',
				'taxonomy'       => 'category',
				'taxonomy_cats'  => '',
				'posts_per_page' => -1,
            ], $atts
		);

		extract( $atts );

		$meta_key = ( isset( $meta_key ) && $meta_key == 'dislike' ) ? 'pvm_dislike_votes_count' : 'pvm_like_votes_count';

		$args = [
			'post_status'         => 'publish',
			'post_type'           => $post_type,
			'meta_key'            => $meta_key,
			'order'               => 'DESC',
			'orderby'             => 'meta_value_num',
			'posts_per_page'      => $posts_per_page,
			'ignore_sticky_posts' => 1,
			'meta_query'          => [
				[
					'key'     => 'bwl_pvm_display_status',
					'value'   => 1,
					'compare' => '=',
				],
			],
		];

		if ( isset( $taxonomy_cats ) && $taxonomy_cats != '' ) {

			$taxonomy_cats = explode( ',', $taxonomy_cats );

			$args['tax_query'] = [
				'relation' => 'AND',
				[
					'taxonomy'         => $taxonomy,
					'field'            => 'slug',
					'terms'            => $taxonomy_cats,
					'include_children' => 0,
					'operator'         => 'IN',
				],
			];
		}

		$loop = new WP_Query( $args );

		global $post;

		$output = '';

		$title_tag_style = '';

		if ( $loop->have_posts() ) :

			$item_number = 1;

			while ( $loop->have_posts() ) :

				$loop->the_post();

				$id = get_the_ID();

				$post_title = get_the_title();

				$post_url = get_the_permalink( $id );

				$item_number_html = ( $show_number == 1 ) ? $item_number++ . '. ' : '';

				$output .= '<' . $title_tag . ' ' . $title_tag_style . '><a href="' . $post_url . '">' . $item_number_html . $post_title . '</a></' . $title_tag . '>';

				$output .= do_shortcode( '[bwl_pvm id=' . $id . '/]' );

			endwhile;

    endif;

		global $wpdb;

		// echo $wpdb->last_query;

		return $output;
	}
}
