<?php
namespace BPVMWP\Callbacks\Shortcodes;

/**
 * Class LoginForm Callbacks
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class ShareBtnCb {

	/**
	 * Generates the shortcode output.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string The login form HTML.
	 */
	public function get_the_output( $atts ) {

		$atts = shortcode_atts([
			'post_id' => '',
		], $atts);
		extract( $atts ); // phpcs:ignore

		if ( empty( $post_id ) ) {
			return '';
		}

		$share_title = esc_html__( 'Share', 'bwl-pro-voting-manager' );

		return "<div class='bpvm-share-links'>
										 <strong>{$share_title}</strong>
										 " . $this->get_the_social_links( $post_id ) . '
								</div>';
	}

	/**
	 * Generates the social links.
	 *
	 * @param int $post_id The post ID.
	 * @return string The social links HTML.
	 */
	private function get_the_social_links( $post_id ) {
		$post_title = get_the_title( $post_id );
		$post_url   = get_permalink( $post_id );

		$links = [
			[
				'url'   => 'https://twitter.com/share?url=' . $post_url . '&text=' . $post_title,
				'title' => esc_html__( 'Tweet It', 'bwl-pro-voting-manager' ),
				'icon'  => 'twitter',
			],
			[
				'url'   => 'http://www.facebook.com/sharer.php?u=' . $post_url,
				'title' => esc_html__( 'Share at Facebook', 'bwl-pro-voting-manager' ),
				'icon'  => 'facebook',
			],
			[
				'url'   => 'http://pinterest.com/pin/create/button/?url=' . $post_url,
				'title' => esc_html__( 'Share at Pinterest', 'bwl-pro-voting-manager' ),
				'icon'  => 'pinterest',
			],
			[
				'url'   => 'https://linkedin.com/shareArticle?mini=true&url=' . $post_url,
				'title' => esc_html__( 'Share at LinkedIn', 'bwl-pro-voting-manager' ),
				'icon'  => 'linkedin',
			],
			[
				'url'   => 'mailto:?subject=' . $post_title . '&body=' . $post_url,
				'title' => esc_html__( 'Share via Email', 'bwl-pro-voting-manager' ),
				'icon'  => 'envelope-o',
			],
		];

		$output = '';
		$class  = 'btn-share pvm_share';

		foreach ( $links as $link ) {
						$output .= "<a class={$class} href={$link['url']} title={$link['title']} target='_blank'>
														<i class='fa fa-" . $link['icon'] . "'></i>
												 </a>";
		}
		return $output;
	}
}
