<?php
namespace BPVMWP\Callbacks\Shortcodes;

use BPVMWP\Helpers\BpvmHelper;

/**
 * Class Posts List Callback
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class PostsListCb {

	/**
	 * Generates the shortcode output.
     *
	 * @param array $atts Shortcode attributes.
	 * @return string The posts list HTML.
	 */
	public function get_the_output( $atts ) {

		$atts = shortcode_atts([
			'ids'         => '',
			'title_tag'   => 'h4',
			'show_number' => 0,
		], $atts);
		extract( $atts ); // phpcs:ignore

		$ids_lists       = explode( ',', $ids );
		$title_tag_style = '';
		$output          = '';

		if ( count( $ids_lists ) > 0 ) {

			$counter = 1;

			foreach ( $ids_lists as $id ) {

				$display_status = BpvmHelper::get_vote_box_display_status( $id );

				if ( $display_status !== 0 ) {

					$counter_html = ( intval( $show_number ) === 1 ) ? ( $counter++ ) . '. ' : '';

					$post_title = get_the_title( $id );
					$post_url   = get_the_permalink( $id );

					$link    = "<a href='{$post_url}' title='{$post_title}'>{$counter_html} {$post_title}</a>";
					$output .= "<$title_tag {$title_tag_style}>{$link}</$title_tag>";

					$output .= do_shortcode( '[bwl_pvm id=' . $id . ' status="' . $display_status . '"/]' );
				}
			}
		}
		return $output;
	}
}
