<?php
namespace BPVMWP\Callbacks\Shortcodes;

use WP_Query;

/**
 * Class LoginForm Callbacks
 *
 * @since: 1.1.1
 * @package BPVMWP
 */
class PostsFilterCb {

	/**
	 * Generates the shortcode output.
	 *
	 * @param array $atts Shortcode attributes.
	 * @return string The login form HTML.
	 * @example This shortcode will display liked/ disliked posts with limit and date filter
	 * PARAMETER INFO:
	 * order_type: liked/disliked
     * limit: no of post you want to display.
     * date_filter: Allow to run date filter query
     * interval: any number like 30, means display last 30 days top/down voted posts
     * SHORTCODE EXAMPLES:
     * Display 20 top liked post of last 30 days : [bpvm_filter order_type='liked' limit=20 date_filter=1 interval=30 /]
     * Display 20 top disliked  post of last 30 days : [bpvm_filter order_type='disliked' limit=20 date_filter=1 interval=30 /]
	 */
	public function get_the_output( $atts ) {

			global $post;

			$post_id = get_the_ID();

			$atts = shortcode_atts(
                [
					'class'         => 'bpvm-posts',
					'order_type'    => 'liked', // liked/disliked
					'order'         => 'ASC',
					'post_type'     => 'post',
					'taxonomy'      => 'category',
					'taxonomy_cats' => '',
					'date_filter'   => 0,
					'interval'      => '1 week', // 1 day, 1 week, 1 month, custom(any date range)
					'vis'           => date( 'Y-m-d' ),
					'vie'           => date( 'Y-m-d' ),
					'limit'         => 999999999,
					'animation'     => 0,
					'custom_header' => 1,
					'thumb'         => 1,
					'thumb_size'    => 'pvm-post-thumb',
					'te_cat'        => '',
					'voting_filter' => 1,
					'show_stats'    => 1,
					'only_active'   => 0,
					'vote_box'      => 0,
				], $atts
			);

			extract( $atts ); // phpcs:ignore

			// echo "<pre>";
			// print_r($atts);
			// echo "</pre>";

			$pvm_voted_post_string = '';

			// New Voting Filter.
			// Introduced from version 1.1.0

		if ( $interval == '1 week' || $interval == '1 day' || $interval == '1 month' || $interval == 'custom' ) {

				global $wpdb;

				// @Vote type keys: 1=like, 2=dislike.
				// @Introduced in version : 1.1.0

			if ( $order_type == 'disliked' ) {

						$vote_type = 2;
			} else {

					$vote_type = 1;
			}

				// @Interval Ranges Script
				// @Introduced in version: 1.1.0
				// @Improved in version 1.1.3

				$post_table = $wpdb->prefix . 'posts'; // posts table from database.

			if ( $interval == 'custom' ) {

					// Custom Date Range.

					$query = 'SELECT postid, SUM(`total_votes`) AS tv FROM `' . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
							. '     WHERE 1 AND ' . $wpdb->prefix . 'bpvm_summary.postid = ' . $post_table . '.ID'
							. '     AND ' . $post_table . ".post_status = 'publish'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
											`vote_date`>='{$vis}' AND `vote_date`<='{$vie}' GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
			} elseif ( $interval == '1 month' ) {

					// 1 Month interval from current date.

					$query = 'SELECT postid, SUM(`total_votes`) AS tv FROM `' . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
							. '     WHERE 1 AND ' . $wpdb->prefix . 'bpvm_summary.postid = ' . $post_table . '.ID'
							. '     AND ' . $post_table . ".post_status = 'publish'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
									" . $wpdb->prefix . "bpvm_summary.vote_date BETWEEN now() - interval 1 month AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
			} elseif ( $interval == '1 day' ) {

					// 1 day interval from current date.

					$query = 'SELECT postid, SUM(`total_votes`) AS tv FROM `' . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
							. '     WHERE 1 AND ' . $wpdb->prefix . 'bpvm_summary.postid = ' . $post_table . '.ID'
							. '     AND ' . $post_table . ".post_status = 'publish'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
									" . $wpdb->prefix . "bpvm_summary.vote_date BETWEEN now() - interval 1 day AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
			} else {

					// 1 Week interval from current date. ( Default )

					$query = 'SELECT postid, SUM(`total_votes`) AS tv FROM `' . $wpdb->prefix . 'bpvm_summary`,`' . $post_table . '` '
							. '     WHERE 1 AND ' . $wpdb->prefix . 'bpvm_summary.postid = ' . $post_table . '.ID'
							. '     AND ' . $post_table . ".post_status = 'publish'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.post_type = '{$post_type}'"
							. '     AND ' . $wpdb->prefix . "bpvm_summary.vote_type={$vote_type} AND 
									" . $wpdb->prefix . "bpvm_summary.vote_date BETWEEN now() - interval 1 week AND now() GROUP BY `postid` ORDER BY tv {$order} limit 0, {$limit}";
			}

				$query_results = $wpdb->get_results( $query );

				// echo $wpdb->last_query;

			if ( count( $query_results ) > 0 ) :

					$counter = 1;

					$pvm_voted_post_string .= $this->get_filter_header( $custom_header );

				foreach ( $query_results as $bpvm_filter_post_info ) {

						$bpvm_post_id = $bpvm_filter_post_info->postid;

						$bpvm_post_total_votes = $bpvm_filter_post_info->tv;

						$post_thumb = '';

					if ( has_post_thumbnail( $bpvm_post_id ) && $thumb == 1 ) {

						$post_thumb = get_the_post_thumbnail( $bpvm_post_id, $thumb_size );
					}

						$pvm_voted_post_string .= '<div class="pvm-custom-info">';

						$pvm_voting_box = '';

					if ( $vote_box == 1 ) {
							$pvm_voting_box .= do_shortcode( '[bwl_pvm id=' . $bpvm_post_id . ' class="bpvm_filter_vbox"/]' );
					}

						$pvm_voted_post_string .= '<div class="post-position">' . $counter . '</div>'
								. '<div class="post-title"><a href="' . get_permalink( $bpvm_post_id ) . '" title="' . get_the_title( $bpvm_post_id ) . '" class="pvm-filtered-post">' . $post_thumb . '<span>' . get_the_title( $bpvm_post_id ) . '</span></a>' . $pvm_voting_box . '</div>'
								. '<div class="post-votes">' . $bpvm_post_total_votes . '</div>';
						$pvm_voted_post_string .= '</div>';

						++$counter;
				}

					else :

							$pvm_voted_post_string = '<p>' . esc_html__( 'Sorry, No Post Found!', 'bwl-pro-voting-manager' ) . '</p>';

					endif;

					wp_reset_query();
		} else {

				// echo "random";

				// That filter Works for the older version.
				// $te_cat = preg_replace('~&#x0*([0-9a-f]+);~ei', 'chr(hexdec("\\1"))', $te_cat);

			if ( $order_type == 'disliked' ) {

					$meta_key = 'pvm_dislike_votes_count';
			} else {

					$meta_key = 'pvm_like_votes_count';
			}

				// Default Arguments.

				$args = [
					'post_status'         => 'publish',
					'post_type'           => $post_type,
					'order'               => 'DESC',
					'meta_key'            => $meta_key,
					'orderby'             => 'meta_value_num',
					'posts_per_page'      => $limit,
					'ignore_sticky_posts' => 1,
				];

				// Allowed Only Active Meta Query.

				if ( isset( $only_active ) && $only_active == 1 ) {

						$args['meta_query'] = [
							[
								'key'     => 'bwl_pvm_display_status',
								'compare' => '=',
								'value'   => 1,
								'type'    => 'numeric',
							],
						];
				}

				// Event Filter.
				if ( class_exists( 'TribeEvents' ) && $post_type == 'tribe_events' && $te_cat != '' ) {
						$args['tribe_events_cat'] = $te_cat;
				}
				if ( isset( $date_filter ) && $date_filter == 1 ) {

					if ( ! is_numeric( $interval ) ) {
							$interval = 30;
					}

					// Date Limit:
					$args['meta_query'] = [
						[
							'key'     => 'vote_date',
							'value'   => date( 'Y-m-d', strtotime( '-' . $interval . ' days' ) ),
							'compare' => '>=',
						],
					];
				}
				if ( $post_type == 'post-format-gallery' ) {

					unset( $args['post_type'] ); // unset post type field

					$args['tax_query'] = [
						[
							'taxonomy' => 'post_format',
							'field'    => 'slug',
							'terms'    => 'post-format-gallery',
						],
					];
				}

				$loop = new WP_Query( $args );

				global $post;

				$counter = 1;

				if ( $loop->have_posts() ) :

						$pvm_voted_post_string .= $this->get_filter_header( $custom_header );

					while ( $loop->have_posts() ) :

							$loop->the_post();

							$post_thumb = '';

						if ( has_post_thumbnail() && $thumb == 1 ) {
							$post_thumb = get_the_post_thumbnail( $post->ID, $thumb_size );
						}

						if ( $order_type == 'disliked' ) {

								$pvm_dislike_votes_count = get_post_meta( $post->ID, 'pvm_dislike_votes_count', true );

								$bpvm_post_total_votes = ( $pvm_dislike_votes_count == '' ) ? 0 : $pvm_dislike_votes_count;
						} else {

								$pvm_like_votes_count = get_post_meta( $post->ID, 'pvm_like_votes_count', true );

								$bpvm_post_total_votes = ( $pvm_like_votes_count == '' ) ? 0 : $pvm_like_votes_count;
						}

							$pvm_voted_post_string .= '<div class="pvm-custom-info">';

							$pvm_voted_post_string .= '<div class="post-position">' . $counter . '</div>'
									. '<div class="post-title"><a href="' . get_permalink() . '" title="' . get_the_title() . '" class="pvm-filtered-post">' . $post_thumb . '<span>' . get_the_title() . '</span></a></div>'
									. '<div class="post-votes">' . $bpvm_post_total_votes . '</div>';

							$pvm_voted_post_string .= '</div>';

							++$counter;

							endwhile;

						wp_reset_query();

					else :

							$pvm_voted_post_string = '<p>' . esc_html__( 'No Post Found!', 'bwl-pro-voting-manager' ) . '</p>';

					endif;
		}

			return $pvm_voted_post_string;
	}


	/**
	 * Get the filter header.
	 *
	 * @param int $header_status Header status.
	 * @return string Filter header HTML.
	 */
	public function get_filter_header( $header_status = 0 ) {

		if ( $header_status === 0 ) {
			return '';
		}

		return '<div class="pvm-custom-header">'
        . '<div class="post-position">' . esc_html__( 'Position', 'bwl-pro-voting-manager' ) . '</div>'
        . '<div class="post-title">' . esc_html__( 'Title', 'bwl-pro-voting-manager' ) . '</div>'
        . '<div class="post-votes">' . esc_html__( 'Votes', 'bwl-pro-voting-manager' ) . '</div>'
        . '</div>';
	}
}
