<?php
namespace BPVMWP\Callbacks\Pages;

use Xenioushk\BwlPluginApi\Api\View\ViewApi;
use BPVMWP\Traits\LicenseTraits;

/**
 * Class for Download Report page callbacks.
 *
 * @package BPVMWP
 */
class VisualReportCb extends ViewApi {

	use LicenseTraits;

	/**
	 * Load the email template settings page.
	 */
	public function load_template() {

		wp_enqueue_script( 'bpvm-chart-js' );

		add_shortcode( 'reaction_bar_chart', [ $this, 'render_reaction_bar_chart_shortcode' ] );

		$data = [];

		$this->render( BPVM_VIEWS_DIR . 'Admin/Report/tpl_visual_report.php', $data );

	}

	public function render_reaction_bar_chart_shortcode() {

		$date_wise_votes_data = get_option( BPVM_DATE_WISE_VOTES_COUNT );

		$default_interval = 30;

		$interval = sanitize_text_field( isset( $_GET['interval'] ) ? intval( $_GET['interval'] ) : $default_interval );

		$interval = $interval < 1 ? $default_interval : $interval;

		$report_data = count( $date_wise_votes_data['data'] ) > $interval ? array_slice( $date_wise_votes_data['data'], 0, $interval ) : $date_wise_votes_data['data'];

		// Sample data – ideally replace with DB query
		$labels   = [];
		$likes    = [];
		$dislikes = [];

		// Group data by date (preserve order from $report_data)
		$date_map = [];
		foreach ( $report_data as $row ) {
			$date = $row['vote_date'];
			if ( ! isset( $date_map[ $date ] ) ) {
				$date_map[ $date ] = [ 'like' => 0, 'dislike' => 0 ];
			}
			if ( intval( $row['vote_type'] ) === 1 ) {
				$date_map[ $date ]['like'] += intval( $row['total_votes'] );
			} elseif ( intval( $row['vote_type'] ) === 2 ) {
				$date_map[ $date ]['dislike'] += intval( $row['total_votes'] );
			}
		}

		// Do NOT sort with ksort(); this preserves the original order
		// ksort( $date_map );

		// Build labels and data arrays
		foreach ( $date_map as $date => $votes ) {
			$labels[]   = date( 'd-m-y', strtotime( $date ) );
			$likes[]    = $votes['like'];
			$dislikes[] = $votes['dislike'];
		}

		ob_start();
		?>
<canvas id="reactionChart" width="600" height="180"></canvas>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('reactionChart').getContext('2d');

    const data = {
    labels: <?php echo json_encode( $labels ); ?>,
    datasets: [{
        label: 'Likes',
        data: <?php echo json_encode( $likes ); ?>,
        backgroundColor: 'rgba(54, 162, 235, 0.7)'
        },
        {
        label: 'Dislikes',
        data: <?php echo json_encode( $dislikes ); ?>,
        backgroundColor: 'rgba(255, 99, 132, 0.7)'
        }
    ]
    };

    const config = {
    type: 'bar',
    data: data,
    options: {
        responsive: true,
        plugins: {
        legend: {
            position: 'top'
        },
        title: {
            display: true,
            text: 'Likes vs Dislikes (Last <?php echo esc_html( $interval ); ?> days report)'
        }
        },
        scales: {
        y: {
            beginAtZero: true,
            title: {
            display: true,
            text: 'Count'
            }
        },
        x: {
            title: {
            display: true,
            text: 'Date'
            }
        }
        }
    }
    };

    new Chart(ctx, config);
});
</script>
		<?php
		return ob_get_clean();
	}
}
