<?php
namespace BPVMWP\Callbacks\Pages;

use Xenioushk\BwlPluginApi\Api\View\ViewApi;

/**
 * Class for Plugin Addons page callbacks.
 *
 * @package BPVMWP
 */
class PluginAddonsCb extends ViewApi {

	/**
	 * Load the addon template page.
	 */
	public function load_template() {

		$doc_repo          = 'https://xenioushk.github.io/docs-plugins-addon/bpvm-addon/';
		$download_repo     = 'https://bluewindlab.net/product/';
		$static_assets_dir = 'https://xenioushk.github.io/bwl-static-assets/previews/addon/';

		$data = [
			'page_title' => BPVM_PLUGIN_TITLE . ' Addons',
			'addons'     => [
				[
					'title'    => 'Recaptcha Addon',
					'doc'      => "{$doc_repo}recap/index.html",
					'download' => 'https://1.envato.market/recaptcha-addon',
					'preview'  => $static_assets_dir . 'recap.jpg',
				],
				[
					'title'    => 'Undo My Vote Addon',
					'doc'      => "{$doc_repo}umva/index.html",
					'download' => 'https://1.envato.market/umv-addon',
					'preview'  => $static_assets_dir . 'umva.jpg',
				],
				[
					'title'    => 'User Vote Tracker',
					'doc'      => "{$doc_repo}uvta/index.html",
					'download' => "{$download_repo}user-vote-tracker-addon/",
					'preview'  => $static_assets_dir . 'uvta.jpg',
				],
				[
					'title'    => 'WooCommerce Product Voting Addon',
					'doc'      => "{$doc_repo}wpva/index.html",
					'download' => "{$download_repo}woocommerce-product-voting-addon/",
					'preview'  => $static_assets_dir . 'wpva.jpg',
				],
			],
		];

		$this->render( BPVM_VIEWS_DIR . 'Admin/Addons/tpl_plugin_addons.php', $data );

	}
}
