<?php
namespace BPVMWP\Callbacks\Pages;

use Xenioushk\BwlPluginApi\Api\View\ViewApi;
use BPVMWP\Traits\LicenseTraits;

/**
 * Class for License page callbacks.
 *
 * @package BPVMWP
 */
class LicenseCb extends ViewApi {

	use LicenseTraits;

	/**
	 * Load the email template settings page.
	 */
	public function load_template() {

		$verification_type = ( isset( $_GET['bwlverify'] ) && sanitize_text_field( $_GET['bwlverify'] ) === 'offline' ) ? 'offline' : 'online'; // phpcs:ignore
		$license_data      = $this->get_license_info();

		$tpl_dir = BPVM_VIEWS_DIR . 'Admin/License';

		$data = [
			'title'             => BPVM_PLUGIN_TITLE . ' License Page',
			'license_data'      => $license_data,
			'license_faqs'      => $this->get_license_faqs(),
			'verification_type' => $verification_type,
			'tpl_form'          => "{$tpl_dir}/tpl_{$verification_type}_form.php",
			'tpl_license_info'  => "{$tpl_dir}/tpl_license_info.php",
			'tpl_license_faqs'  => "{$tpl_dir}/tpl_license_faqs.php",
		];

		$this->render( "{$tpl_dir}/index.php", $data );

	}
}
