<?php
namespace BPVMWP\Callbacks\Notices\NoticeBlocks;

use BPVMWP\Traits\TraitAdminNotice;

/**
 * Class License Notice Block.
 *
 * Handles the notice message, key, and schedule.
 *
 * @package BPVMWP
 */
class LicenseNoticeBlockCb {

	use TraitAdminNotice;

	/**
	 * The notice key.
	 *
	 * @var string
	 * @note change the key.
	 */
	private static $key = 'bpvm_license_activation_status';

	/**
	 * Display the plugin notices.
	 */
	public function get_the_notice() {

		// Set notice parameters.
		// @params: msg, key, start, status, is_dismissable, noticeClass
		$notice = [
			'noticeClass'    => 'error',
			'msg'            => '🔐 Please <a href="' . BPVM_ADMIN_LICENSE_URL . '" class="bwl_plugins_notice_text--danger bwl_plugins_notice_text--bold">ACTIVATE YOUR COPY</a> of the plugin to unlock premium options and official support of ' . BPVM_PLUGIN_TITLE . '.',
			'key'            => self::$key,
			'status'         => ( BPVM_PRODUCT_VERIFIED_STATUS === 1 ) ? 1 : 0,
			'is_dismissable' => 0,
		];

		return $notice;
	}
}
