<?php
namespace BPVMWP\Callbacks\FrontendAjaxHandlers;

use BPVMWP\Helpers\PluginConstants;

/**
 * Class for dislike vote feddback message callback.
 *
 * @package BPVMWP
 */
class DislikeFeedbackCb {

	/**
	 * Set email content type.
	 */
	public function set_email_content_type() {
		return 'text/html';
	}

	/**
	 * Save Feedback Message
	 */
	public function save() {

		if ( check_ajax_referer( 'bpvm_frontend_nonce', 'nonce' ) ) {

			$options = PluginConstants::$plugin_options;
			$post_id = $_REQUEST['post_id'];

			// We are going to create an unique ID

			$pvm_feedback_message_unique_id = 'pvm_feedback_list_' . $post_id; // so idea is we are going to add post id after vairable name

			// Get the previous feedback message.

			$previous_feedback_messages = get_post_meta( $post_id, $pvm_feedback_message_unique_id, true );

			$prev_pvm_feedback_message = ( empty( $previous_feedback_messages ) ) ? [] : $previous_feedback_messages;

			$prev = $prev_pvm_feedback_message;

			$prev_pvm_feedback_message[] = sanitize_text_field( $_REQUEST['feedback_message_box'] );

			update_post_meta( $post_id, $pvm_feedback_message_unique_id, $prev_pvm_feedback_message, $prev );

			// Send Email to administrator.

			$pvm_feedback_email_status = intval( $options['pvm_feedback_email_status'] ?? 1 );

			if ( $pvm_feedback_email_status ) {

				$to = $options['pvm_feedback_admin_email'] ?? get_bloginfo( 'admin_email' );

				$email    = 'user@email.com';
				$subject  = apply_filters( 'pvm_feedback_subject', esc_html__( 'New Feedback Submitted!', 'bwl-pro-voting-manager' ) );
				$edit_url = get_admin_url( "post.php?post&#61;$post_id&#38;action&#61;edit" );

				$pvm_feedback_email_header = '<p>' . esc_html__( 'Hello Administrator', 'bwl-pro-voting-manager' ) . ',<br>' . esc_html__( 'A new Feedback has been submitted by a user.', 'bwl-pro-voting-manager' ) . '</p><hr />';
				$pvm_feedback_email_footer = '<p><strong>' . esc_html__( 'Review Feedback', 'bwl-pro-voting-manager' ) . ':</strong> ' . $edit_url . '<br>' . esc_html__( 'Thank You!', 'bwl-pro-voting-manager' ) . '</p>';

				$body  = $pvm_feedback_email_header;
				$body .= sprintf( '<div><blockquote>%s</blockquote></div>',sanitize_text_field( $_REQUEST['feedback_message_box'] ) );
				$body .= $pvm_feedback_email_footer;

				$headers[] = 'From: ' . apply_filters( 'pvm_feedback_header', esc_html__( 'New Feedback', 'bwl-pro-voting-manager' ) ) . " <$email>";

				add_filter( 'wp_mail_content_type', [ $this,'set_email_content_type' ] );

				\wp_mail( $to, $subject, $body, $headers );

				remove_filter( 'wp_mail_content_type', [ $this,'set_email_content_type' ] );
			}

			$status = [
				'pvm_feedback_status' => 1,
			];
		} else {

			$status = [
				'pvm_feedback_status' => 0,
			];

		}

		echo wp_json_encode( $status );

		wp_die();
	}
}
