<?php
namespace BPVMWP\Callbacks\FrontendAjaxHandlers;

use BPVMWP\Helpers\AddonsHelper;
use BPVMWP\Helpers\BpvmHelper;
use BPVMWP\Helpers\Common;
use BPVMWP\Helpers\PluginConstants;
use BPVMWP\Helpers\VoteStatusChecker;

/**
 * Class for count votes callback.
 *
 * @package BPVMWP
 */
class CountVotesCb {

	/**
	 * Add votes count.
	 */
	public function add() {

		if ( check_ajax_referer( 'bpvm_frontend_nonce', 'nonce' ) ) {

			// check if user logged in or not.

			// Get plugin options data.
			$pvm_data = PluginConstants::$plugin_options;

			// Get the login check status for submitting vote.
			// @default: login is not required.

			$pvm_login_status = false;

			// Default user is 0.
			// @param: 0=visitor.
			$user_id = 0;

			if ( isset( $pvm_data['pvm_login_status'] ) && $pvm_data['pvm_login_status'] == 1 ) {

				if ( is_user_logged_in() ) :
					$pvm_login_status = true;
					$current_user     = wp_get_current_user();
					$user_id          = $current_user->ID;
				endif;

				if ( $pvm_login_status == false ) {

					$data = [
						'status' => 0,
						'msg'    => apply_filters( 'pvm_msg_login_required', esc_html__( 'Please log in to submit your vote!', 'bwl-pro-voting-manager' ) ),
					];

					echo wp_json_encode( $data );

					wp_die();
				}
			}

			/*--- START DEBUG AREA ---*/

			// $random_ip = array('192.10.10.1','192.10.10.2','192.10.10.3');

			// $ip = $random_ip[rand(0,2)];
			// $ip = '192.10.10.4';

			/*--- END DEBUG AREA ---*/

			$pvm_voted_ip = [];

			// Get the user IP address.
			$user_ip = $_SERVER['REMOTE_ADDR'];
			// $ip          = MY_TEST_IP; // get user IP address.

			// Get current post id.
			$post_id = $_POST['post_id'];

			// Get the vote status. Like(1) or Dislike(0)
			$vote_status = $_POST['vote_status'];

			// Vote Type. Like(1) && Dislike(2).
			// Important Note: This vote type value is used only for the database storage.

			$voteType = ( $vote_status == 0 ) ? 2 : 1;

			// Get all the voted IP address for the current post.
			$meta_IP = get_post_meta( $post_id, 'pvm_voted_ip' );  // Get voters'IPs for the current post

			if ( is_array( $meta_IP ) && ! empty( $meta_IP[0] ) && $meta_IP[0] != 1 ) {
				$pvm_voted_ip = $meta_IP[0];
			}

			/*
			* @Description: Date Wise Votes Counter. Example: For the post with ID 1 received 4 likes and 5 dislikes on the date 04-10-2023
			* @Since: 1.0.9
			* @Store Data: As a post meta data. pvm_liked_votes_by_date and pvm_disliked_votes_by_date
			*/

			// Date Wise Like Voting Counter

			$pvm_current_date        = date( 'Y-m-d' );
			$pvm_current_date_time   = $pvm_current_date . ' ' . date( 'H:i:s' );
			$pvm_liked_votes_by_date = get_post_meta( $post_id, 'pvm_liked_votes_by_date' );  // Get Liked vote per date wise for the current post

			$pvm_liked_votes_by_date_info = ( is_array( $pvm_liked_votes_by_date ) && ! empty( $pvm_liked_votes_by_date[0] ) ) ? $pvm_liked_votes_by_date[0] : [];

			if ( is_array( $pvm_liked_votes_by_date ) && ! empty( $pvm_liked_votes_by_date[0] )
            && in_array( $pvm_current_date, array_keys( $pvm_liked_votes_by_date[0] ) )
			) {

				$pvm_like_vote_update_status                       = 1;
				$pvm_liked_votes_by_date_counter                   = $pvm_liked_votes_by_date[0][ $pvm_current_date ]; // store meta submission counter value.
				$pvm_liked_votes_by_date_info[ $pvm_current_date ] = $pvm_liked_votes_by_date_counter + 1;
			} else {

				$pvm_like_vote_update_status                       = 0;
				$pvm_liked_votes_by_date_counter                   = 0; // if no one submitted voted yet, initialize pvm_submission_counter variable.
				$pvm_liked_votes_by_date_info[ $pvm_current_date ] = $pvm_liked_votes_by_date_counter + 1;
			}

			$pvm_liked_date_wise_total_votes = $pvm_liked_votes_by_date_counter + 1;

			// Date Wise DisLike Voting Counter

			// Get Disliked vote per date wise for the current post
			$pvm_disliked_votes_by_date = get_post_meta( $post_id, 'pvm_disliked_votes_by_date' );

			$pvm_disliked_votes_by_date_info = ( is_array( $pvm_disliked_votes_by_date ) && ! empty( $pvm_disliked_votes_by_date[0] ) ) ? $pvm_disliked_votes_by_date[0] : [];

			if ( is_array( $pvm_disliked_votes_by_date )
            && ! empty( $pvm_disliked_votes_by_date[0] )
            && in_array( $pvm_current_date, array_keys( $pvm_disliked_votes_by_date[0] ) )
			) {

				$pvm_dislike_vote_update_status = 1;
				// store meta submission counter value.
				$pvm_disliked_votes_by_date_counter                   = $pvm_disliked_votes_by_date[0][ $pvm_current_date ];
				$pvm_disliked_votes_by_date_info[ $pvm_current_date ] = $pvm_disliked_votes_by_date_counter + 1;
			} else {

				$pvm_dislike_vote_update_status = 0;
				// if no one submitted voted yet, initialize pvm_submission_counter variable.
				$pvm_disliked_votes_by_date_counter                   = 0;
				$pvm_disliked_votes_by_date_info[ $pvm_current_date ] = $pvm_disliked_votes_by_date_counter + 1;
			}

			$pvm_disliked_date_wise_total_votes = $pvm_disliked_votes_by_date_counter + 1;

			/*-- End of Date Wise Voting Counter --*/

			/*--- START SUBMISSON COUNTER SECTION ---*/

			$meta_submission_counter = get_post_meta( $post_id, 'pvm_submission_counter' );  // Get voters'IPs for the current post

			// Get the submission counter value
			$pvm_submission_counter = ( ! empty( $meta_submission_counter ) ) ? $meta_submission_counter[0] : [];

			// Two step checking.
			// IP filtering.
			// Time Interval.
			// If function return false, then we are going to insert/update value in to databse.

			$pvm_vote_checking_result = VoteStatusChecker::has_user_already_voted( $post_id );

			// status: 0=new vote, 1=already voted, 2=limit crossed

			if ( $pvm_vote_checking_result['status'] == 0 ) {

				$pvm_voted_ip[ $user_ip ] = time(); // store current server time

				$post_type = get_post_type( $post_id );

				$like_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id );

				$dislike_vote_counter = BpvmHelper::bpvm_get_vote_counts_meta( $post_id, 2 );

				// echo '<pre>';
				// print_r( is_array( $pvm_submission_counter ) );
				// print_r( $user_ip );
				// echo '</pre>';

				if ( isset( $pvm_submission_counter[ $user_ip ] ) && ! empty( $pvm_submission_counter[ $user_ip ] ) ) {

					$pvm_submission_counter[ $user_ip ] = $pvm_submission_counter[ $user_ip ] + 1;

				} else {
					if ( ! is_array( $pvm_submission_counter ) ) {
						$pvm_submission_counter = [];
					}
					$pvm_submission_counter[ $user_ip ] = 0;
				}
				/*--- Clear Hourly Vote Counter  ---*/

				if ( $pvm_vote_checking_result['pvm_clear_counter'] == 1 ) {
					$pvm_submission_counter[ $user_ip ] = 1;
				}

				// Save IP and increase votes count

				global $wpdb;
				$bpvm_voting_data_table    = TABLE_BPVM_DATA; // for deatils. each day info.
				$bpvm_voting_summary_table = TABLE_BPVM_SUMMARY; // daily summary.
				$bpvm_data_primary_id      = 0; // Get bpvm_data_primary_id

				// Start Refactored code.

				$total_vote_counter = $like_vote_counter + $dislike_vote_counter + 1;

				// End of Refactored code.

				if ( $voteType == 1 ) {

					// Like Vote Couter.

					update_post_meta( $post_id, 'pvm_liked_votes_by_date', $pvm_liked_votes_by_date_info );
					update_post_meta( $post_id, 'pvm_like_votes_count', ++$like_vote_counter );
					update_post_meta( $post_id, 'pvm_voted_ip', $pvm_voted_ip );
					update_post_meta( $post_id, 'vote_date', $pvm_current_date );
					update_post_meta( $post_id, 'pvm_submission_counter', $pvm_submission_counter );

					// Insert Each Like Vote Entry.
					$wpdb->insert(
                        $bpvm_voting_data_table,
                        [
							'postid'    => $post_id,
							'post_type' => $post_type,
							'vote_type' => $voteType, // like=1, dislike=2
							'votes'     => 1, // default is 1.
							'vote_date' => $pvm_current_date_time,
							'voted_ip'  => $user_ip,
							'user_id'   => $user_id,
                        ],
                        [ '%d', '%s', '%d', '%d', '%s', '%s', '%d' ]
					);

					$bpvm_data_primary_id = $wpdb->insert_id; // get last id

					// Summary Section.

					if ( $pvm_like_vote_update_status == 1 ) {

						// post type and post id required.

						$wpdb->update(
							$bpvm_voting_summary_table,
							[
								'total_votes' => $pvm_liked_date_wise_total_votes, // default is 1.
								'last_voted'  => $pvm_current_date_time,
							], // Update Data
							[
								'postid'    => $post_id,
								'post_type' => $post_type,
								'vote_type' => $voteType,
								'vote_date' => $pvm_current_date,
							], // Where Condition
							[ '%d', '%s' ], // Update Data Format
							[ '%d', '%s', '%d', '%s' ] // Where Condition Format
						);
					} else {

						$wpdb->insert(
                            $bpvm_voting_summary_table,
                            [
								'postid'      => $post_id,
								'post_type'   => $post_type,
								'vote_type'   => $voteType, // like=1, dislike=2
								'vote_date'   => $pvm_current_date,
								'total_votes' => $pvm_liked_date_wise_total_votes, // default is 1.
								'last_voted'  => $pvm_current_date_time,
                            ],
                            [ '%d', '%s', '%d', '%s', '%d', '%s' ]
						);
					}
				} else {

					// Dislike Vote Counter
					update_post_meta( $post_id, 'pvm_disliked_votes_by_date', $pvm_disliked_votes_by_date_info );
					update_post_meta( $post_id, 'pvm_dislike_votes_count', ++$dislike_vote_counter );
					update_post_meta( $post_id, 'pvm_voted_ip', $pvm_voted_ip );
					update_post_meta( $post_id, 'vote_date', $pvm_current_date );
					update_post_meta( $post_id, 'pvm_submission_counter', $pvm_submission_counter );

					// Insert Each DisLike Vote Entry.
					$wpdb->insert(
                        $bpvm_voting_data_table,
                        [
							'postid'    => $post_id,
							'post_type' => $post_type,
							'vote_type' => $voteType, // like=1, dislike=2
							'votes'     => 1, // default is 1.
							'vote_date' => $pvm_current_date_time,
							'voted_ip'  => $user_ip,
							'user_id'   => $user_id,
                        ],
                        [ '%d', '%s', '%d', '%d', '%s', '%s' ]
					);

					$bpvm_data_primary_id = $wpdb->insert_id; // get last id

					// Summary Section.

					if ( $pvm_dislike_vote_update_status == 1 ) {

						// post type and post id required.

						$wpdb->update(
                            $bpvm_voting_summary_table,
                            [
								'total_votes' => $pvm_disliked_date_wise_total_votes, // default is 1.
								'last_voted'  => $pvm_current_date_time,
                            ], // Data – array of data to update as column->value pairs
                            [ 'postid' => $post_id, 'post_type' => $post_type, 'vote_type' => 2, 'vote_date' => $pvm_current_date ], // Where – array of data to match as column->value pairs
                            [ '%d', '%s' ], // Data Format
                            [ '%d', '%s', '%d', '%s' ] // Where Format
						);
					} else {

						$wpdb->insert(
                            $bpvm_voting_summary_table,
                            [
								'postid'      => $post_id,
								'post_type'   => $post_type,
								'vote_type'   => $voteType, // like=1, dislike=2
								'vote_date'   => $pvm_current_date,
								'total_votes' => $pvm_disliked_date_wise_total_votes, // default is 1.
								'last_voted'  => $pvm_current_date_time,
                            ],
                            [ '%d', '%s', '%d', '%s', '%d', '%s' ]
						);
					}
				}

				// Added percentage display option in version 1.1.5

				$pvm_like_vote_percentage    = ceil( BpvmHelper::calculate_percentage( $total_vote_counter, $like_vote_counter ) );
				$pvm_dislike_vote_percentage = 100 - $pvm_like_vote_percentage;

				if ( isset( $pvm_data['pvm_display_result_percentage'] ) && $pvm_data['pvm_display_result_percentage'] == 1 ) {
					$like_vote_counter    = $pvm_like_vote_percentage . '%';
					$dislike_vote_counter = $pvm_dislike_vote_percentage . '%';
				}

				$data = [
					'status'               => 1,
					'like_vote_counter'    => $like_vote_counter,
					'dislike_vote_counter' => $dislike_vote_counter,
					'like_percentage'      => $pvm_like_vote_percentage,
					'dislike_percentage'   => $pvm_dislike_vote_percentage,
					'total_vote_counter'   => $total_vote_counter,
					'vote_status'          => $vote_status,
					'msg'                  => $pvm_vote_checking_result['msg'] . $this->get_undo_vote_button( $post_id, $post_type, $bpvm_data_primary_id, $voteType ),
				];

				/*-- Taxonomy Filter Addon For BWL Pro Voting Manager --*/

				if ( class_exists( 'BPVM_TFA' ) && shortcode_exists( 'bpvm_tfa' ) && ! empty( $_POST['tfa_vis'] ) && ! empty( $_POST['tfa_vie'] ) ) {
					$get_last_vote_results = get_last_vote_results( $_POST['post_id'], $_POST['tfa_vis'], $_POST['tfa_vie'] );

					$dr_like_votes    = $get_last_vote_results['like_data']['tv'];
					$dr_dislike_votes = isset( $get_last_vote_results['dislike_data']['tv'] ) ? $get_last_vote_results['dislike_data']['tv'] : 0;
					$dr_total_votes   = $dr_like_votes + $dr_dislike_votes;

					$data['like_vote_counter']    = $dr_like_votes;
					$data['dislike_vote_counter'] = $dr_dislike_votes;
					$data['total_vote_counter']   = $dr_total_votes;
				}

				// Added in version 1.1.4
				update_post_meta( $post_id, 'pvm_total_votes', $total_vote_counter );
			} elseif ( $pvm_vote_checking_result['status'] == 1 ) {

				$data = [
					'status' => 0,
					'msg'    => $pvm_vote_checking_result['msg'],
				];
			} elseif ( $pvm_vote_checking_result['status'] == 2 ) {

				$data = [
					'status' => 0,
					'msg'    => $pvm_vote_checking_result['msg'],
				];
			} else {

				// Default !

				$data = [
					'status' => 0,
					'msg'    => $pvm_vote_checking_result['msg'],
				];
			}
		} else {

			$data = [
				'status' => 0,
				'msg'    => esc_html__( 'Invalid request!', 'bwl-pro-voting-manager' ),
			];

		}

		echo wp_json_encode( $data );
		wp_die();
	}

	/**
	 * Get undo vote button.
	 *
	 * @param int    $post_id            Post ID.
	 * @param string $post_type          Post type.
	 * @param int    $bpvm_data_primary_id BPVM data primary ID.
	 * @param int    $vote_type          Vote type.
	 */
	private function get_undo_vote_button( $post_id, $post_type, $bpvm_data_primary_id, $vote_type ) {

		// If the addon is not activated, return empty string.
		if ( ! AddonsHelper::get_activation_status( 'umvaddon' ) ) {
			return '';
		}

		// Process the button filter.
			$data = [
				'post_id'      => $post_id,
				'post_type'    => $post_type,
				'vote_type'    => $vote_type,
				'bpvm_data_id' => $bpvm_data_primary_id,
			];
			return apply_filters( 'umva_button_filter', $data );

	}
}
