<?php
namespace BPVMWP\Callbacks\Filters\Frontend;

use BPVMWP\Helpers\PluginConstants;

/**
 * Class for voting interface callabck.
 *
 * @package BPVMWP
 * @since: 1.0.0
 * @author: Mahbub Alam Khan
 */
class VotingInterfaceCb {


	/**
	 * The post ID.
	 *
	 * @var int
	 */
	private $post_id;

	/**
	 * The voting box display status.
	 *
	 * @var int
	 */
	private $display_status;

	/**
	 * Get the vote box layout.
	 *
	 * @param string $content The content of the product tab.
	 *
	 * @return array
	 */
	public function get_the_layout( $content ) {

		// Get the current post id.
		$post_id = get_the_ID();

		$this->post_id = $post_id;

		// Retrive options.
		$pvm_data = PluginConstants::$plugin_options;

		// We are going to check if the voting box is enabled for this post type.
		// @param: 0=disabled, 1=enabled
		if ( isset( $pvm_data[ 'pvmpt_' . get_post_type( $post_id ) ] )
				&& intval( $pvm_data[ 'pvmpt_' . get_post_type( $post_id ) ] ) === 0 ) {

					return $content;
		}

		// Get single post voting box display status.
		// @param: 0/null=hide, 1=show, 2=closed, 3=paused, 4=date ranage
		$bwl_pvm_display_status = get_post_meta( $this->post_id, BPVM_VOTE_BOX_STATUS, true );

		if ( $bwl_pvm_display_status !== '' ) {

			// Type casting and trun it to integer.
			$bwl_pvm_display_status = intval( $bwl_pvm_display_status );

			if ( intval( $bwl_pvm_display_status ) === 0 ) {
				return $content;
			}
		}

		/*----- Voting Range Status: Introduced in version  1.0.7 -----*/

		// Check Date Status In here.

		$bpvm_vote_start_date = get_post_meta( $post_id, BPVM_VOTE_START_DATE, true );
		$bpvm_vote_end_date   = get_post_meta( $post_id, BPVM_VOTE_END_DATE, true );
		$bpvm_current_date    = date( 'm' ) . '/' . date( 'd' ) . '/' . date( 'Y' );

		// Voting Interval Issue fixed in version 1.1.0

		if ( $bwl_pvm_display_status == 4 && $bpvm_vote_start_date != '' && $bpvm_vote_end_date != '' && $bpvm_current_date >= $bpvm_vote_start_date && $bpvm_current_date <= $bpvm_vote_end_date ) {
			// Voting Date Range Set and allowed for voting.
			$bwl_pvm_display_status = 1;
		} elseif ( $bwl_pvm_display_status == 4 && $bpvm_vote_start_date != '' && $bpvm_vote_end_date != '' && $bpvm_current_date < $bpvm_vote_start_date ) {
			// voting time is not started yet.
			$bwl_pvm_display_status = 4;
		} elseif ( $bwl_pvm_display_status == 4 && $bpvm_vote_start_date != '' && $bpvm_vote_end_date != '' && $bpvm_current_date > $bpvm_vote_end_date ) {
			// Voting time has been closed.
			$bwl_pvm_display_status = 5;
		}

		// Check if the voting box is enabled for this post.
		$this->display_status = $bwl_pvm_display_status;

		// @Description: Display voting interface in blog lists/category/tag/archive page.
		// @Since: 1.1.4

		$bpvm_display_auto_interface = $pvm_data['bpvm_display_auto_interface'] ?? 0;

		if ( ! is_singular( get_post_type( $post_id ) ) ) {
			// This is an update for modal window request.
			$post_id = $_REQUEST['id'] ?? $post_id;
			return ( $bpvm_display_auto_interface == 1 ) ?
								$content . do_shortcode( "[bwl_pvm id='" . $post_id . "' status='" . $bwl_pvm_display_status . "' /]" ) :
								$content;
		}

		$content = $this->get_layout_by_location( $content );

		return $content;
	}

	/**
	 * Get the layout by location.
	 *
	 * @param string $content The content of the product tab.
	 *
	 * @return string
	 */
	private function get_layout_by_location( $content ) {
		// Get the voting box display location.
		// @param: 1/null=After post (default), 2=before post
		$location = intval( get_post_meta( $this->post_id, 'bwl_pvm_display_location', true ) );

		return ( $location !== 2 ) ?
			$content . do_shortcode( '[bwl_pvm status=' . $this->display_status . ' /]' ) :
			do_shortcode( '[bwl_pvm status=' . $this->display_status . ' /]' ) . $content;
	}
}
