<?php
namespace BPVMWP\Callbacks\DashboardWidgets;

use Xenioushk\BwlPluginApi\Api\View\ViewApi;
use BPVMWP\Controllers\Admin\Report\CalculateAllVotes;

use BPVMWP\Traits\LicenseTraits;
/**
 * Class for DashboardWidgetsCb
 *
 * @package BPVM
 */
class DashboardWidgetsCb extends ViewApi {
	use LicenseTraits;

	/**
	 * Get the plugin analytics summary.
	 *
	 * @return void
	 */
	public function get_plugin_summary() {

		$data = [
			'footer_links' => $this->get_dashboard_footer_links(),
			'offer_info'   => $this->get_offer_info(),
			'vote_counts'  => $this->get_vote_counts_info(),
		];

		$this->render( BPVM_VIEWS_DIR . 'Admin/DashboardWidgets/tpl_plugin_summary.php', $data );
	}

	/**
	 * Get the footer links for the dashboard.
	 *
	 * @return array
	 */
	private function get_dashboard_footer_links() {
		$footer_links = [
			[
				'title' => '🛠️ ' . esc_html__( 'Options', 'bwl-pro-voting-manager' ),
				'url'   => BPVM_ADMIN_OPTIONS_PANEL_URL,
			],
			[
				'title' => '📊 ' . esc_html__( 'Report', 'bwl-pro-voting-manager' ),
				'url'   => BPVM_ADMIN_REPORT_PANEL_URL,
			],
			[
				'title' => '🧩 ' . esc_html__( 'Addons', 'bwl-pro-voting-manager' ),
				'url'   => BPVM_ADMIN_ADDONS_URL,
			],
			[
				'title' => '📘 ' . esc_html__( 'Documentation', 'bwl-pro-voting-manager' ),
				'url'   => BPVM_PRODUCT_DOC,
				'nt'    => 1,
			],
		];
		return $footer_links;
	}

	/**
	 * Get the offer information.
	 *
	 * @return array
	 */
	private function get_offer_info() {

		$offer = [
			'status' => 0,
		];

		// Fetch the offer data.
		$option_data = get_option( BPVM_CRON_OFFER_OPTION_ID );

		// Return if the offer data is empty.
		if ( empty( $option_data ) ) {
			return $offer;
		}

		$offer_data = $option_data['data'];

		// This is the default date time.
		$now    = date( 'Y-m-d' );
		$stdate = $offer_data['stdate'] ?? $now;
		$exdate = $offer_data['exdate'] ?? $now;

		$show_offer = strtotime( $now ) >= strtotime( $stdate ) && strtotime( $now ) <= strtotime( $exdate );

		if ( ! $show_offer ) {
			return $offer;
		}

		$cta_btn = sprintf(
			'<br><a href="%s" class="button bwl-text-bold bwl-text-success" target="_blank">Get Now</a>',
			$offer_data['btnurl']
		);

		$msg = sprintf(
			'🎉 <strong>%s</strong> %s',
			$offer_data['details'],
			$cta_btn
		);

		return [
			'status' => 1,
			'msg'    => $msg,
		];

	}

	/**
	 * Get the license information.
	 *
	 * @return array
	 */
	private function get_vote_counts_info() {
		$votes_count          = ( new CalculateAllVotes() )::get_total_votes_counts();
		$total_likes_count    = $votes_count['likes'] ?? 0;
		$total_dislikes_count = $votes_count['dislikes'] ?? 0;
		$total_votes_count    = $total_likes_count + $total_dislikes_count;

		return [
			'total_votes_count'    => $total_votes_count,
			'total_likes_count'    => $total_likes_count,
			'total_dislikes_count' => $total_dislikes_count,
		];

	}
}
