<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers;

/**
 * Class for user feedback callbacks.
 *
 * @package BPVMWP
 */
class UserFeedbackCb {

	/**
	 * Delete feedback message.
	 *
	 * @var string
	 */
	public function remove() {

		if ( ! check_ajax_referer( BPVM_ADMIN_NONCE_ID, 'nonce', false ) ) {
			wp_send_json_error( [ 'msg' => BPVM_ICON_ERROR . ' ' . esc_html__( 'Invalid nonce', 'bwl-pro-voting-manager' ) ] );
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( [ 'msg' => BPVM_ICON_ERROR . ' ' . esc_html__( 'Permission denied', 'bwl-pro-voting-manager' ) ] );
		}

			$feedback_index = sanitize_text_field( $_POST['feedback_index'] );
			$post_id        = sanitize_text_field( $_POST['post_id'] );

			// so idea is we are going to add post id after vairable name
			$pvm_feedback_message_unique_id = 'pvm_feedback_list_' . $post_id;

			$pvm_feedback_messages = get_post_meta( $post_id, $pvm_feedback_message_unique_id );

		if ( isset( $pvm_feedback_messages[0][ $feedback_index ] ) ) {
			// Remove the feedback message from the array.
			unset( $pvm_feedback_messages[0][ $feedback_index ] );

			// Update the post meta with the modified array.
			update_post_meta( $post_id, $pvm_feedback_message_unique_id, $pvm_feedback_messages[0] );

			// Count the number of feedback messages.
			$count = ( isset( $pvm_feedback_messages[0] ) && ! empty( $pvm_feedback_messages[0] ) ) ? count( $pvm_feedback_messages[0] ) : 0;

			$post_data = [
				'count' => $count,
				'msg'   => BPVM_ICON_SUCCESS . ' ' . esc_html__( 'Feedback removed successfully.', 'bwl-pro-voting-manager' ),
			];

			wp_send_json_success( $post_data );
		} else {
			wp_send_json_error( [ 'msg' => BPVM_ICON_ERROR . ' ' . esc_html__( 'Feedback message not found!', 'bwl-pro-voting-manager' ) ] );
		}
	}
}
