<?php
namespace BPVMWP\Callbacks\AdminAjaxHandlers\Report;

use BPVMWP\Helpers\Common;
use Xenioushk\BwlPluginApi\Api\Database\QueryManagerApi;

/**
 * Class for getting vote data.
 * Generate Voting Data in data grid.
 *
 * @package BPVMWP
 */
class VoteDataCb {

	/**
	 * Current DB table.
	 *
	 * @var string
	 */
	private $current_db_table;

	/**
	 * Selected fields for the query.
	 *
	 * @var string
	 */
	private $selected_fields;

	/**
	 * Vote info type. (Summary/ Details)
	 * Default: 1
	 * 1=Summary, 2=Details
	 *
	 * @var string
	 */
	private $vote_info_type;

	/**
	 * Get the votes data.
	 */
	private function get_filters() {

		$post_id               = $_REQUEST['post_id']; // Get post ID
		$post_type             = $_REQUEST['post_type'] ?? 'post'; // WordPress Available Post Types.
		$mv_post_filters       = $_REQUEST['mv_post_filters'] ?? ''; // Filter Type: Like/Dislike.
		$this->vote_info_type  = intval( $_REQUEST['mv_vote_info_type'] ?? 1 ); // Voting Info type: Summary/ Details
		$pvm_custom_date_range = $_REQUEST['pvm_custom_date_range'] === 'true' ? 1 : 0; // Get Custom Date range status.
		// Ending date of filter.
		$pvm_filter_start_date = empty( $_REQUEST['pvm_filter_start_date'] ) ? '2013-04-01' : $_REQUEST['pvm_filter_start_date'];
		$pvm_filter_end_date   = empty( $_REQUEST['pvm_filter_end_date'] ) ? date( 'Y-m-d' ) : $_REQUEST['pvm_filter_end_date'];

		// Last field comma is required.
		$common_fields = 'ID,postid,post_type,vote_type,';

		if ( $this->vote_info_type === 2 ) {
			$this->current_db_table = TABLE_BPVM_DATA;
			$this->selected_fields  = $common_fields . 'votes, vote_date,user_id';
		} else {
			$this->current_db_table = TABLE_BPVM_SUMMARY;
			$this->selected_fields  = $common_fields . 'total_votes as votes, vote_date';
		}

		$filters = [
			'postid'    => $post_id,
			'post_type' => $post_type,
		];

		if ( ! empty( $mv_post_filters ) ) {
			$filters['vote_type'] = $mv_post_filters;
		}

		if ( $pvm_custom_date_range ) {
			$filters['vote_date >='] = [ 'value' => $pvm_filter_start_date, 'operator' => '>=' ];
			$filters['vote_date <='] = [ 'value' => $pvm_filter_end_date, 'operator' => '<=' ];
		}

		return $filters;
	}

	/**
	 * Format the date.
	 *
	 * @param array $data Data to format.
	 *
	 * @return array Formatted data.
	 */
	public function format_date( $data = [] ) {

		$formatted_data = [];

		foreach ( $data as $item ) {

			$item['ID'] = ( $this->vote_info_type === 2 ) ?
			sprintf('<input type="checkbox"  class="deleteRow" value="%d" data-post_id="%d" data-votes="%d" data-vote_type="%d" 
			data-vote_date="%s"/>',
                $item['ID'],
                $item['postid'],
                $item['votes'],
                $item['vote_type'],
			$item['vote_date']) : '-';

			$item['vote_date'] = Common::human_date_format( $item['vote_date'] );
			$item['vote_type'] = ( intval( $item['vote_type'] ) === 2 ) ? '👎🏻' : '👍';
			$formatted_data[]  = $item;
		}

		return $formatted_data;

	}

	/**
	 * Get the data.
	 *
	 * @return void
	 */
	public function get_data() {

		$start  = isset( $_POST['start'] ) ? intval( $_POST['start'] ) : 0;
		$length = isset( $_POST['length'] ) ? intval( $_POST['length'] ) : 10;
		$draw   = isset( $_POST['draw'] ) ? intval( $_POST['draw'] ) : 1;

		$page = floor( $start / $length ) + 1;

		// Default ordering
		$order_by  = 'ID';
		$order_dir = 'DESC';

		// Handle DataTables ordering
		if ( ! empty( $_POST['order'] ) && ! empty( $_POST['columns'] ) ) {
			$order_column_index = $_POST['order'][0]['column'];
			$order_dir          = $_POST['order'][0]['dir'] === 'asc' ? 'ASC' : 'DESC';
			$order_by           = sanitize_sql_orderby( $_POST['columns'][ $order_column_index ]['data'] );
		}

		// Build filters
		$filters = [];

		$filters = $this->get_filters();

		$crud = new QueryManagerApi( $this->current_db_table );

		// Fetch results

		$args = [
			'page'            => $page,
			'per_page'        => $length,
			'filters'         => $filters,
			'selected_fields' => $this->selected_fields,
			'order_by'        => $order_by,
			'order_dir'       => $order_dir,
		];

		$results = $crud->get_items( $args );

		wp_send_json([
            'draw'            => $draw,
            'recordsTotal'    => $results['total'],
            'recordsFiltered' => $results['total'],
            'data'            => $this->format_date( $results['data'] ), // super important to format the data.
		]);

	}
}
